---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-Wasm Browser Sample

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **ローカル開発サーバーのポート番号**: 実際のポート番号は設定により異なる可能性あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/mono/sample/wasm/browser/wwwroot/index.html` (7-16行目)
- E-02: `src/mono/sample/wasm/browser/wwwroot/main.js` (1-35行目)
- E-03: `src/mono/sample/wasm/browser/Program.cs` (1-28行目)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (2行目)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (2-4行目)
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` (56-75行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面タイトルは「Wasm Browser Sample」 | E-01: index.html 7行目 `<title>Wasm Browser Sample</title>` | ○ |
| C-02 | 「究極の問いへの答え」を表示する | E-01: index.html 16行目 `Answer to the Ultimate Question...` | ○ |
| C-03 | 結果は span#out に表示される | E-01: index.html 16行目 `<span id="out"></span>` | ○ |
| C-04 | main.js をモジュールとして読み込む | E-01: index.html 11行目 `<script type='module' src="./main.js">` | ○ |
| C-05 | dotnet と exit をインポートする | E-02: main.js 4行目 `import { dotnet, exit } from './_framework/dotnet.js'` | ○ |
| C-06 | displayMeaning 関数が DOM を更新する | E-02: main.js 6-9行目 displayMeaning 関数定義 | ○ |
| C-07 | dotnet.create() でランタイム初期化 | E-02: main.js 16-18行目 `await dotnet...create()` | ○ |
| C-08 | setModuleImports で JS 関数を公開 | E-02: main.js 20-26行目 setModuleImports 呼び出し | ○ |
| C-09 | appendElementOnExit: true を設定 | E-02: main.js 17行目 withConfig 内の設定 | ○ |
| C-10 | exitOnUnhandledError: true を設定 | E-02: main.js 17行目 withConfig 内の設定 | ○ |
| C-11 | forwardConsole: true を設定 | E-02: main.js 17行目 withConfig 内の設定 | ○ |
| C-12 | PrintMeaning に Promise を渡す | E-02: main.js 29行目 `exports.Sample.Test.PrintMeaning(delay(2000).then(() => 42))` | ○ |
| C-13 | dotnet.runMainAndExit() を呼び出す | E-02: main.js 31行目 `await dotnet.runMainAndExit()` | ○ |
| C-14 | エラー時に exit(2, err) で終了 | E-02: main.js 34行目 `exit(2, err)` | ○ |
| C-15 | C# Main で DisplayMeaning(42) を呼び出す | E-03: Program.cs 15行目 `DisplayMeaning(42)` | ○ |
| C-16 | JSImport 属性で displayMeaning を定義 | E-03: Program.cs 19-20行目 `[JSImport("Sample.Test.displayMeaning", "main.js")]` | ○ |
| C-17 | JSExport 属性で PrintMeaning を公開 | E-03: Program.cs 22-26行目 `[JSExport]` 付き PrintMeaning メソッド | ○ |
| C-18 | PrintMeaning は非同期メソッド | E-03: Program.cs 23行目 `internal static async Task PrintMeaning` | ○ |
| C-19 | コンソールに "Meaning of life is" を出力 | E-03: Program.cs 25行目 `Console.WriteLine("Meaning of life is " + await meaningPromise)` | ○ |
| C-20 | Main は Task<int> を返す | E-03: Program.cs 13行目 `public static Task<int> Main(string[] args)` | ○ |
| C-21 | 関連機能に Mono が含まれる | E-05: 画面機能マッピング.csv 2行目 | ○ |
| C-22 | 関連機能に WebAssembly Workload が含まれる | E-05: 画面機能マッピング.csv 3行目 | ○ |
| C-23 | 関連機能に WasmAppBuilder が含まれる | E-05: 画面機能マッピング.csv 4行目 | ○ |
| C-24 | 単一画面で他画面への遷移なし | E-06: 画面遷移図.md 56-75行目「単一画面で完結」 | ○ |
| C-25 | ローカル開発は http://localhost:8000/ | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ローカル開発サーバーのポート番号（8000）の根拠
  - 候補：プロジェクト設定ファイル / launch.json / README.md

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ポート番号は環境依存であり、ドキュメント全体の正確性には影響しない

## 6) レビュアーチェックリスト（最小）
- [ ] ローカル開発サーバーのデフォルトポートを確認（8000 が正しいか）
- [ ] dotnet.js のビルド時生成パスが正しいか確認
- [ ] JSImport/JSExport の動作説明が実際のコードと一致しているか確認
