---
generated_at: 2026-01-30 12:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-Hot Reload Sample

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/mono/sample/mbr/browser/wwwroot/index.html` (1-22行目)
- E-02: `src/mono/sample/mbr/browser/wwwroot/main.js` (1-23行目)
- E-03: `src/mono/sample/mbr/browser/Program.cs` (1-34行目)
- E-04: `src/mono/sample/mbr/browser/Program_v1.cs` (1-34行目)
- E-05: `src/mono/sample/mbr/browser/Program_v2.cs` (1-34行目)
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` (11行目)
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (37-40行目)
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md` (56-75行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面タイトルは「Wasm Hot Reload Sample」 | E-01: index.html 15行目 `<h3 id="header">Wasm Hot Reload Sample</h3>` | ○ |
| C-02 | Update ボタンが存在 | E-01: index.html 17行目 `<button id="update">Update</button>` | ○ |
| C-03 | 最大 2 回までの表示がある | E-01: index.html 17行目 `Click here (upto 2 times)` | ○ |
| C-04 | 環境変数 DOTNET_MODIFIABLE_ASSEMBLIES を設定 | E-02: main.js 5行目 `.withEnvironmentVariable("DOTNET_MODIFIABLE_ASSEMBLIES", "debug")` | ○ |
| C-05 | getAssemblyExports で WasmDelta.dll を取得 | E-02: main.js 8行目 | ○ |
| C-06 | update と testMeaning メソッドを取得 | E-02: main.js 9-10行目 | ○ |
| C-07 | #update クリックイベント登録 | E-02: main.js 13-17行目 | ○ |
| C-08 | クリック時に "applied update" をログ出力 | E-02: main.js 15行目 | ○ |
| C-09 | クリック後に testMeaning() を呼び出し | E-02: main.js 16行目 | ○ |
| C-10 | 初期値を outElement.innerHTML に表示 | E-02: main.js 18行目 | ○ |
| C-11 | "ready" をログ出力 | E-02: main.js 19行目 | ○ |
| C-12 | エラー時に "WASM ERROR" をログ出力 | E-02: main.js 21行目 | ○ |
| C-13 | DeltaHelper.Make() でインスタンス作成 | E-03: Program.cs 14行目 | ○ |
| C-14 | Main で "Hello, World!" を出力 | E-03: Program.cs 18行目 | ○ |
| C-15 | TestMeaning は JSExport で公開 | E-03: Program.cs 21-25行目 | ○ |
| C-16 | 初期バージョンの TestMeaning は 42 を返す | E-03: Program.cs 24行目 `return 42` | ○ |
| C-17 | Update は JSExport で公開 | E-03: Program.cs 27-32行目 | ○ |
| C-18 | Update で replacer.Update(assm) を呼び出し | E-03: Program.cs 31行目 | ○ |
| C-19 | 1回目更新後は 43 を返す | E-04: Program_v1.cs 24行目 `return 43` | ○ |
| C-20 | 2回目更新後は 128 を返す | E-05: Program_v2.cs 24行目 `return 128` | ○ |
| C-21 | MonoDelta 名前空間を使用 | E-03: Program.cs 8行目 `using MonoDelta` | ○ |
| C-22 | typeof(Test).Assembly でアセンブリを取得 | E-03: Program.cs 30行目 | ○ |
| C-23 | 関連機能に System.Reflection.Emit が含まれる | E-07: 画面機能マッピング.csv 38行目 | ○ |
| C-24 | 単一画面で他画面への遷移なし | E-08: 画面遷移図.md | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、高い信頼性

## 6) レビュアーチェックリスト（最小）
- [ ] 環境変数 DOTNET_MODIFIABLE_ASSEMBLIES=debug が正しく設定されるか確認
- [ ] Update ボタンクリック後に値が 42 -> 43 -> 128 と変化するか確認
- [ ] デルタファイルがビルド時に正しく生成されるか確認
- [ ] 3回目以降のクリックでエラーにならないか確認
