---
generated_at: 2026-01-30 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：11-Stopwatch.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/mono/wasm/templates/templates/browser/wwwroot/index.html`
- E-02: `src/mono/wasm/templates/templates/browser/wwwroot/main.js`
- E-03: `src/mono/wasm/templates/templates/browser/Program.cs`
- E-04: `src/mono/wasm/templates/templates/browser/browser.0.csproj`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面タイトルが「Stopwatch」である | E-01 (17行目: `<h1>Stopwatch</h1>`) | ○ |
| C-02 | 経過時間表示の初期値が「loading...」である | E-01 (19行目: `<span id="time"><i>loading...</i></span>`) | ○ |
| C-03 | Pauseボタンとresetボタンが存在する | E-01 (22-23行目) | ○ |
| C-04 | main.jsでdotnetモジュールをインポートしている | E-02 (4行目: `import { dotnet }`) | ○ |
| C-05 | withApplicationArgumentsで"start"引数を設定している | E-02 (7行目: `.withApplicationArguments("start")`) | ○ |
| C-06 | setModuleImportsでdom.setInnerText関数を登録している | E-02 (10-14行目) | ○ |
| C-07 | Pauseボタンのクリックでexports.StopwatchSample.Toggle()を呼び出す | E-02 (25-28行目) | ○ |
| C-08 | Resetボタンのクリックでexports.StopwatchSample.Reset()を呼び出す | E-02 (19-22行目) | ○ |
| C-09 | dotnet.runMain()でC#のMainメソッドを実行する | E-02 (32行目) | ○ |
| C-10 | Program.csでSystem.Diagnostics.Stopwatchを使用している | E-03 (3行目, 19行目) | ○ |
| C-11 | "start"引数で自動開始する条件分岐がある | E-03 (8-9行目) | ○ |
| C-12 | 1秒ごとにRender()を呼び出す無限ループがある | E-03 (11-15行目: `while(true) { ... await Task.Delay(1000); }`) | ○ |
| C-13 | Toggle()メソッドがJSExport属性を持つ | E-03 (27行目: `[JSExport]`) | ○ |
| C-14 | Reset()メソッドがJSExport属性を持つ | E-03 (42行目: `[JSExport]`) | ○ |
| C-15 | SetInnerTextがJSImport属性を持つ | E-03 (24行目: `[JSImport("dom.setInnerText", "main.js")]`) | ○ |
| C-16 | 起動時に"Hello, Browser!"をコンソール出力する | E-03 (6行目: `Console.WriteLine("Hello, Browser!");`) | ○ |
| C-17 | プロジェクトがMicrosoft.NET.Sdk.WebAssembly SDKを使用している | E-04 (1行目) | ○ |
| C-18 | 関連機能としてMono、WebAssembly Workload、WasmAppBuilderが記載されている | E-06 (11行目: 画面No 11の機能マッピング) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] HTML構造がindex.htmlと一致している
- [x] JavaScriptのイベント処理がmain.jsと一致している
- [x] C#のメソッド仕様がProgram.csと一致している
- [x] 関連機能が画面機能マッピング.csvと一致している
