---
generated_at: 2026-01-30 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-WasmBasicTestApp.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/mono/wasm/testassets/WasmBasicTestApp/App/wwwroot/index.html`
- E-02: `src/mono/wasm/testassets/WasmBasicTestApp/App/wwwroot/main.js`
- E-03: `src/mono/wasm/testassets/WasmBasicTestApp/App/Common/Program.cs`
- E-04: `src/mono/wasm/testassets/WasmBasicTestApp/App/WasmBasicTestApp.csproj`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTML構造にspan#out要素が存在する | E-01 (18行目: `<span id="out"></span>`) | ○ |
| C-02 | main.jsとprofiler.jsがモジュールとして読み込まれる | E-01 (13-14行目) | ○ |
| C-03 | URLクエリパラメータからtestパラメータを取得する | E-02 (8-9行目: `const testCase = params.get("test")`) | ○ |
| C-04 | テストケース未指定時にexit(2)でエラー終了する | E-02 (10-12行目) | ○ |
| C-05 | dotnet.withConfigで基本設定を適用する | E-02 (24行目) | ○ |
| C-06 | SatelliteAssembliesTestでloadAllSatelliteResources設定を行う | E-02 (40-44行目) | ○ |
| C-07 | LazyLoadingTestでdiagnosticTracingを有効化する | E-02 (51-53行目) | ○ |
| C-08 | InterpPgoTestでインタープリターPGO設定を行う | E-02 (113-118行目) | ○ |
| C-09 | LogProfilerTestでlogProfilerOptionsを設定する | E-02 (161-168行目) | ○ |
| C-10 | dotnet.create()でランタイムを初期化する | E-02 (186行目) | ○ |
| C-11 | getAssemblyExportsでC#のエクスポート関数を取得する | E-02 (188行目) | ○ |
| C-12 | 未知のテストケースでexit(3)を呼び出す | E-02 (369-370行目) | ○ |
| C-13 | 例外発生時にexit(1)でエラー終了する | E-02 (373-376行目) | ○ |
| C-14 | Program.csで"WasmBasicTestApp"をコンソール出力する | E-03 (4行目) | ○ |
| C-15 | プロジェクトがMicrosoft.NET.Sdk.WebAssembly SDKを使用する | E-04 (1行目) | ○ |
| C-16 | 関連機能としてMono、WebAssembly Workload、WasmAppBuilderが記載されている | E-06 (画面No 12の行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] HTML構造がindex.htmlと一致している
- [x] テストケース一覧がmain.jsのswitch文と一致している
- [x] C#のメソッド仕様がソースコードと一致している
- [x] 関連機能が画面機能マッピング.csvと一致している
