---
generated_at: 2026-01-30 10:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-LibraryMode.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/mono/wasm/testassets/LibraryMode/wwwroot/index.html`
- E-02: `src/mono/wasm/testassets/LibraryMode/wwwroot/main.js`
- E-03: `src/mono/wasm/testassets/LibraryMode/LibraryMode.cs`
- E-04: `src/mono/wasm/testassets/LibraryMode/LibraryMode.csproj`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTMLのbody要素が空である | E-01 (15-16行目: `<body></body>`) | ○ |
| C-02 | main.jsがモジュールとして読み込まれる | E-01 (12行目: `<script type="module" src="./main.js">`) | ○ |
| C-03 | dotnet.create()でランタイムを初期化する | E-02 (6行目) | ○ |
| C-04 | getAssemblyExportsでエクスポート関数を取得する | E-02 (9行目) | ○ |
| C-05 | exports.LibraryMode.Test.MyExport()を呼び出す | E-02 (10行目) | ○ |
| C-06 | 戻り値をWASM EXIT形式でコンソール出力する | E-02 (11行目: `console.log(\`WASM EXIT \${code}\`)`) | ○ |
| C-07 | runMain()は呼び出されない | E-02 (ファイル全体を確認、runMainの呼び出しなし) | ○ |
| C-08 | MyExportメソッドにJSExport属性がある | E-03 (11行目: `[JSExport]`) | ○ |
| C-09 | MyExportメソッドが100を返す | E-03 (15行目: `return 100`) | ○ |
| C-10 | コンソールに"TestOutput -> WASM Library MyExport is called"を出力する | E-03 (14行目) | ○ |
| C-11 | OutputTypeがLibraryに設定されている | E-04 (6行目: `<OutputType>Library</OutputType>`) | ○ |
| C-12 | 関連機能としてMono、WebAssembly Workload、WasmAppBuilderが記載されている | E-06 (画面No 13の行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] HTML構造がindex.htmlと一致している
- [x] JavaScriptの処理フローがmain.jsと一致している
- [x] C#のエクスポートメソッドがLibraryMode.csと一致している
- [x] プロジェクト設定がLibraryMode.csprojと一致している
- [x] 関連機能が画面機能マッピング.csvと一致している
