---
generated_at: 2026-01-30 10:15:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-WasmBrowserRunMainOnly.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/mono/wasm/testassets/WasmBrowserRunMainOnly/wwwroot/index.html`
- E-02: `src/mono/wasm/testassets/WasmBrowserRunMainOnly/wwwroot/main.js`
- E-03: `src/mono/wasm/testassets/WasmBrowserRunMainOnly/Program.cs`
- E-04: `src/mono/wasm/testassets/WasmBrowserRunMainOnly/WasmBrowserRunMainOnly.csproj`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTMLのbody要素が空である | E-01 (16-17行目: `<body></body>`) | ○ |
| C-02 | main.jsでフィンガープリント付きスクリプトが読み込まれる | E-01 (13行目) | ○ |
| C-03 | dotnet.runMainAndExit()でMain関数を実行する | E-02 (6行目: `await dotnet.runMainAndExit()`) | ○ |
| C-04 | Main関数がasync Task<int>型で定義されている | E-03 (8行目: `static async Task<int> Main`) | ○ |
| C-05 | TestOutput.WriteLineでメッセージを出力する | E-03 (10行目) | ○ |
| C-06 | "Hello from WasmBrowserRunMainOnly!"を出力する | E-03 (10行目) | ○ |
| C-07 | Task.Delay(1)で非同期待機する | E-03 (11行目: `await Task.Delay(1)`) | ○ |
| C-08 | return 0で正常終了する | E-03 (12行目: `return 0`) | ○ |
| C-09 | プロジェクトがMicrosoft.NET.Sdk.WebAssembly SDKを使用する | E-04 (1行目) | ○ |
| C-10 | フィンガープリント機能が有効化されている | E-04 (9行目: `StaticWebAssetFingerprintPattern`) | ○ |
| C-11 | 関連機能としてMono、WebAssembly Workload、WasmAppBuilderが記載されている | E-06 (画面No 14の行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] HTML構造がindex.htmlと一致している
- [x] JavaScriptの処理フローがmain.jsと一致している
- [x] C#のMain関数がProgram.csと一致している
- [x] 関連機能が画面機能マッピング.csvと一致している
