---
generated_at: 2026-01-30 10:25:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-BlazorBasicTestApp.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/mono/wasm/testassets/BlazorBasicTestApp/App/wwwroot/index.html`
- E-02: `src/mono/wasm/testassets/BlazorBasicTestApp/App/Program.cs`
- E-03: `src/mono/wasm/testassets/BlazorBasicTestApp/App/App.razor`
- E-04: `src/mono/wasm/testassets/BlazorBasicTestApp/App/Layout/MainLayout.razor`
- E-05: `src/mono/wasm/testassets/BlazorBasicTestApp/App/Layout/NavMenu.razor`
- E-06: `src/mono/wasm/testassets/BlazorBasicTestApp/App/BlazorBasicTestApp.csproj`
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | base hrefが"/"に設定されている | E-01 (8行目: `<base href="/" />`) | ○ |
| C-02 | Bootstrapスタイルシートが読み込まれる | E-01 (9行目) | ○ |
| C-03 | div#appにローディングプログレスが表示される | E-01 (17-22行目) | ○ |
| C-04 | blazor-error-uiでエラー表示される | E-01 (25-29行目) | ○ |
| C-05 | blazor.webassembly.jsが読み込まれる | E-01 (30行目) | ○ |
| C-06 | WebAssemblyHostBuilder.CreateDefault()でビルダーを作成 | E-02 (5行目) | ○ |
| C-07 | Appコンポーネントを#appにマウント | E-02 (6行目) | ○ |
| C-08 | HeadOutletをhead::afterにマウント | E-02 (7行目) | ○ |
| C-09 | HttpClientをスコープサービスとして登録 | E-02 (9行目) | ○ |
| C-10 | Routerコンポーネントでルーティングを設定 | E-03 (1行目) | ○ |
| C-11 | MainLayoutをDefaultLayoutとして使用 | E-03 (3行目) | ○ |
| C-12 | NotFoundで"Sorry, there's nothing at this address."を表示 | E-03 (9行目) | ○ |
| C-13 | サイドバー+メインコンテンツ構造のレイアウト | E-04 (2-16行目) | ○ |
| C-14 | Home, Counter, Weatherへのナビゲーションリンク | E-05 (12-26行目) | ○ |
| C-15 | Microsoft.NET.Sdk.BlazorWebAssembly SDKを使用 | E-06 (1行目) | ○ |
| C-16 | 関連機能が画面機能マッピングに記載されている | E-08 (画面No 16の行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] HTML構造がindex.htmlと一致している
- [x] Program.csの起動フローが正しい
- [x] ルーティング設定がApp.razorと一致している
- [x] レイアウト構造がMainLayout.razorと一致している
- [x] ナビゲーションがNavMenu.razorと一致している
- [x] 関連機能が画面機能マッピング.csvと一致している
