---
generated_at: 2026-01-30 10:40:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-Counter（BlazorBasicTestApp）.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/mono/wasm/testassets/BlazorBasicTestApp/App/Pages/Counter.razor`
- E-02: `src/mono/wasm/testassets/BlazorBasicTestApp/App/Layout/NavMenu.razor`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @page "/counter"でルーティング設定 | E-01 (1行目: `@page "/counter"`) | ○ |
| C-02 | PageTitleで"Counter"を設定 | E-01 (3行目: `<PageTitle>Counter</PageTitle>`) | ○ |
| C-03 | h1で"Counter"を表示 | E-01 (5行目: `<h1>Counter</h1>`) | ○ |
| C-04 | p要素でカウント値を表示 | E-01 (7行目: `<p role="status">Current count: @currentCount</p>`) | ○ |
| C-05 | role="status"でアクセシビリティ対応 | E-01 (7行目) | ○ |
| C-06 | btn-primaryクラスでBootstrapスタイル | E-01 (9行目: `class="btn btn-primary"`) | ○ |
| C-07 | @onclickでIncrementCountを呼び出し | E-01 (9行目: `@onclick="IncrementCount"`) | ○ |
| C-08 | currentCountを0で初期化 | E-01 (12行目: `private int currentCount = 0;`) | ○ |
| C-09 | IncrementCount()でcurrentCount++ | E-01 (14-17行目) | ○ |
| C-10 | ナビゲーションメニューにCounterへのリンクがある | E-02 (17-19行目) | ○ |
| C-11 | 関連機能が画面機能マッピングに記載されている | E-04 (画面No 19の行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] @pageディレクティブのパスが正しい
- [x] 表示要素がCounter.razorと一致している
- [x] イベントハンドラの実装が正しい
- [x] 状態管理の実装が正しい
- [x] ナビゲーションメニューとの整合性
- [x] 関連機能が画面機能マッピング.csvと一致している
