---
generated_at: 2026-01-30 12:05:00
metrics:
  claims_total: 30
  claims_with_evidence: 29
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：2-Wasm Browser Advanced Sample

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：29 / 30、根拠なし：1
- 優先レビュー（高）
  1. **ネイティブ fibonacci ライブラリの実装**: C ソースの詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/mono/sample/wasm/browser-advanced/wwwroot/index.html` (1-25行目)
- E-02: `src/mono/sample/wasm/browser-advanced/wwwroot/main.js` (1-116行目)
- E-03: `src/mono/sample/wasm/browser-advanced/Program.cs` (1-115行目)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (3行目)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (5-8行目)
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` (56-75行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面タイトルは「Wasm Browser Advanced Sample」 | E-01: index.html 7行目 `<title>Wasm Browser Advanced Sample</title>` | ○ |
| C-02 | CSP で wasm-unsafe-eval を許可 | E-01: index.html 11行目 `content="default-src 'self'; script-src 'self' 'wasm-unsafe-eval';"` | ○ |
| C-03 | preload で dotnet.boot.js を読み込み | E-01: index.html 14行目 `<link rel="preload" href="./dotnet.boot.js"` | ○ |
| C-04 | prefetch で dotnet.native.js を読み込み | E-01: index.html 15行目 `<link rel="prefetch" href="./dotnet.native.js"` | ○ |
| C-05 | prefetch で dotnet.runtime.js を読み込み | E-01: index.html 16行目 `<link rel="prefetch" href="./dotnet.runtime.js"` | ○ |
| C-06 | カスタムフェッチで testAbort パラメータを使用 | E-02: main.js 24-27行目 `testAbort` 変数とURL パラメータ追加 | ○ |
| C-07 | カスタムフェッチで testError パラメータを使用 | E-02: main.js 28-31行目 `testError` 変数とURL パラメータ追加 | ○ |
| C-08 | maxParallelDownloads: 1 を設定 | E-02: main.js 40行目 `maxParallelDownloads: 1` | ○ |
| C-09 | onConfigLoaded で MONO_LOG_LEVEL を設定 | E-02: main.js 52行目 `config.environmentVariables["MONO_LOG_LEVEL"] = "debug"` | ○ |
| C-10 | browserProfilerOptions を設定 | E-02: main.js 53-56行目 `config.browserProfilerOptions` | ○ |
| C-11 | withResourceLoader でバージョンパラメータ追加 | E-02: main.js 72-75行目 `return \`\${defaultUri}?v=42\`` | ○ |
| C-12 | dotnet.download() を呼び出し | E-02: main.js 77行目 `await dotnet.download()` | ○ |
| C-13 | Module.GL の存在確認 | E-02: main.js 95-97行目 `typeof Module.GL !== "object"` | ○ |
| C-14 | Module.FS.filesystems.IDBFS の存在確認 | E-02: main.js 98-100行目 `typeof Module.FS.filesystems.IDBFS` | ○ |
| C-15 | LibraryImport で fibonacci ライブラリを呼び出し | E-03: Program.cs 44-45行目 `[LibraryImport("fibonacci")]` | ○ |
| C-16 | JSImport で add 関数を呼び出し | E-03: Program.cs 47-48行目 `[JSImport("Sample.Test.add", "main.js")]` | ○ |
| C-17 | JSImport で delay 関数を呼び出し | E-03: Program.cs 50-52行目 `[JSImport("Sample.Test.delay", "main.js")]` | ○ |
| C-18 | TestMeaning で Fibonacci(8) を呼び出し | E-03: Program.cs 64行目 `var half = Fibonacci(8)` | ○ |
| C-19 | TestMeaning で Add(half, half) を呼び出し | E-03: Program.cs 66行目 `return Add(half, half)` | ○ |
| C-20 | IsPrime で素数判定 | E-03: Program.cs 99-113行目 IsPrime メソッド実装 | ○ |
| C-21 | Main でタイムゾーン情報を取得 | E-03: Program.cs 22行目 `TimeZoneInfo.GetSystemTimeZones()` | ○ |
| C-22 | Asia/Tokyo タイムゾーンを検索 | E-03: Program.cs 32行目 `TimeZoneInfo.FindSystemTimeZoneById("Asia/Tokyo")` | ○ |
| C-23 | TimeZoneNotFoundException をキャッチ | E-03: Program.cs 35-38行目 catch ブロック | ○ |
| C-24 | SillyLoop でプロファイラー用サンプル生成 | E-03: Program.cs 69-97行目 SillyLoop メソッド | ○ |
| C-25 | 関連機能に Mono が含まれる | E-05: 画面機能マッピング.csv 5行目 | ○ |
| C-26 | 関連機能に WebAssembly Workload が含まれる | E-05: 画面機能マッピング.csv 6行目 | ○ |
| C-27 | 関連機能に WasmAppBuilder が含まれる | E-05: 画面機能マッピング.csv 7行目 | ○ |
| C-28 | 関連機能にインタープリターが含まれる | E-05: 画面機能マッピング.csv 8行目 | ○ |
| C-29 | 単一画面で他画面への遷移なし | E-06: 画面遷移図.md 56-75行目 | ○ |
| C-30 | fibonacci ライブラリの実装詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- fibonacci ネイティブ C ライブラリの実装詳細
  - 候補：`src/mono/sample/wasm/browser-advanced/*.c` / プロジェクトファイル参照

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - fibonacci ライブラリは外部依存であり、本画面の主要機能には影響しない

## 6) レビュアーチェックリスト（最小）
- [ ] CSP 設定が期待通りに動作するか確認
- [ ] preload/prefetch が正しくリソースを事前取得しているか確認
- [ ] fibonacci ネイティブライブラリのビルド方法を確認
- [ ] カスタムフェッチのリトライロジックが正しく動作するか確認
