---
generated_at: 2026-01-30 10:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-Home（BlazorWebWasm）.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Pages/Home.razor`
- E-02: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Program.cs`
- E-03: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Layout/MainLayout.razor`
- E-04: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Layout/NavMenu.razor`
- E-05: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/BlazorWebWasm.csproj`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @page "/"でルートにマッピング | E-01 (1行目: `@page "/"`) | ○ |
| C-02 | PageTitleで"Home"を設定 | E-01 (3行目: `<PageTitle>Home</PageTitle>`) | ○ |
| C-03 | h1で"Hello, world!"を表示 | E-01 (5行目: `<h1>Hello, world!</h1>`) | ○ |
| C-04 | "Welcome to your new app."を表示 | E-01 (7行目) | ○ |
| C-05 | AddRazorComponents()でコンポーネントを追加 | E-02 (8行目) | ○ |
| C-06 | AddInteractiveWebAssemblyComponents()でWebAssemblyモード追加 | E-02 (9行目) | ○ |
| C-07 | UseStatusCodePagesWithReExecuteで/not-foundにリダイレクト | E-02 (42行目) | ○ |
| C-08 | UseAntiforgery()でCSRF対策 | E-02 (45行目) | ○ |
| C-09 | MapRazorComponents<App>()でコンポーネントマッピング | E-02 (48行目) | ○ |
| C-10 | リクエストログミドルウェアが設定されている | E-02 (16-29行目) | ○ |
| C-11 | サイドバー+メインコンテンツ構造のレイアウト | E-03 | ○ |
| C-12 | Home, Counter, Weatherへのナビゲーションリンク | E-04 (12-27行目) | ○ |
| C-13 | BlazorWebWasmの遷移図にHomeが含まれる | E-08 (BlazorWebWasmセクション) | ○ |
| C-14 | 関連機能が画面機能マッピングに記載されている | E-07 (画面No 20の行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] @pageディレクティブのパスが正しい
- [x] 表示要素がHome.razorと一致している
- [x] サーバー構成がProgram.csと一致している
- [x] レイアウト構造がMainLayout.razorと一致している
- [x] ナビゲーションがNavMenu.razorと一致している
- [x] 関連機能が画面機能マッピング.csvと一致している
