---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：21-Counter（BlazorWebWasm）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）

- E-01: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm.Client/Pages/Counter.razor`（27行）
- E-02: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm.Client/Program.cs`（5行）
- E-03: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Program.cs`（67行）
- E-04: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Routes.razor`（6行）
- E-05: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Layout/MainLayout.razor`（23行）
- E-06: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Layout/NavMenu.razor`（30行）
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-09: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/counter` である | E-01（1行目: `@page "/counter"`） | ○ |
| C-02 | InteractiveWebAssembly レンダリングモードを使用 | E-01（2行目: `@rendermode InteractiveWebAssembly`） | ○ |
| C-03 | currentCount の初期値は 0 | E-01（13行目: `private int currentCount = 0;`） | ○ |
| C-04 | IncrementCount メソッドでカウントを増加 | E-01（15-17行目: `private void IncrementCount() { currentCount++; }`） | ○ |
| C-05 | Click me ボタンで IncrementCount を呼び出す | E-01（10行目: `@onclick="IncrementCount"`） | ○ |
| C-06 | 初回レンダリング時にコンソール出力 | E-01（20-25行目: `OnAfterRender` メソッド） | ○ |
| C-07 | ページタイトルは "Counter" | E-01（4行目: `<PageTitle>Counter</PageTitle>`） | ○ |
| C-08 | カウント表示に role="status" を使用 | E-01（8行目: `<p role="status">`） | ○ |
| C-09 | ボタンに btn btn-primary クラスを適用 | E-01（10行目: `class="btn btn-primary"`） | ○ |
| C-10 | 関連機能は Mono と WebAssembly Workload | E-08（21行目: 画面No 21 のマッピング） | ○ |
| C-11 | 画面カテゴリは Blazor ページ | E-07（22行目: カテゴリ "Blazor ページ"） | ○ |
| C-12 | Home ページとの相互遷移が可能 | E-06（12行目: Home への NavLink）, E-09 | ○ |
| C-13 | NavMenu から Counter へのリンクがある | E-06（18行目: `href="counter"`） | ○ |
| C-14 | MainLayout でサイドバーとメインを分離 | E-05（3-16行目: div 構造） | ○ |
| C-15 | WebAssemblyHostBuilder でクライアント初期化 | E-02（3行目: `WebAssemblyHostBuilder.CreateDefault`） | ○ |
| C-16 | Router で Client アセンブリを追加参照 | E-04（1行目: `AdditionalAssemblies`） | ○ |
| C-17 | エラー時は /Error へリダイレクト | E-03（38行目: `app.UseExceptionHandler("/Error")`） | ○ |
| C-18 | 404 時は /not-found へリダイレクト | E-03（42行目: `UseStatusCodePagesWithReExecute("/not-found")`） | ○ |

## 4) 不足情報（Unknown / Missing）

すべての主張に対して根拠が確認できました。不足情報はありません。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張に根拠があり、ソースコードと整合しています

## 6) レビュアーチェックリスト（最小）

- [ ] Counter.razor のコード内容が設計書の記述と一致しているか確認
- [ ] InteractiveWebAssembly モードの動作が期待通りか確認
- [ ] ナビゲーション遷移が正しく機能するか確認
