---
generated_at: 2026-01-30 12:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-Error（BlazorWebWasm）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）

- E-01: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Components/Pages/Error.razor`（36行）
- E-02: `src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm/Program.cs`（67行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/Error` である | E-01（1行目: `@page "/Error"`） | ○ |
| C-02 | System.Diagnostics を使用 | E-01（2行目: `@using System.Diagnostics`） | ○ |
| C-03 | HttpContext を CascadingParameter として受け取る | E-01（28-29行目: `[CascadingParameter] private HttpContext? HttpContext`） | ○ |
| C-04 | RequestId プロパティが存在 | E-01（31行目: `private string? RequestId`） | ○ |
| C-05 | ShowRequestId は RequestId が空でない場合に true | E-01（32行目: `private bool ShowRequestId => !string.IsNullOrEmpty(RequestId)`） | ○ |
| C-06 | OnInitialized で RequestId を設定 | E-01（34-35行目: `protected override void OnInitialized()`） | ○ |
| C-07 | Activity.Current?.Id を優先的に使用 | E-01（35行目: `RequestId = Activity.Current?.Id ?? HttpContext?.TraceIdentifier`） | ○ |
| C-08 | ページタイトルは "Error" | E-01（4行目: `<PageTitle>Error</PageTitle>`） | ○ |
| C-09 | エラー見出しに text-danger クラスを適用 | E-01（6-7行目: `<h1 class="text-danger">`, `<h2 class="text-danger">`） | ○ |
| C-10 | Request ID を条件付きで表示 | E-01（9-14行目: `@if (ShowRequestId)`） | ○ |
| C-11 | 開発環境への切り替え方法を案内 | E-01（16-24行目: Development Mode セクション） | ○ |
| C-12 | ASPNETCORE_ENVIRONMENT 環境変数の説明がある | E-01（23行目: `ASPNETCORE_ENVIRONMENT`） | ○ |
| C-13 | 関連機能は Mono, DiagnosticSource, WebAssembly Workload | E-04（22行目: 画面No 22 のマッピング） | ○ |
| C-14 | 画面カテゴリは Blazor ページ | E-03（23行目: カテゴリ "Blazor ページ"） | ○ |
| C-15 | エラー発生時に /Error へリダイレクト | E-02（38行目: `app.UseExceptionHandler("/Error")`） | ○ |
| C-16 | 画面遷移図でエラー発生時の遷移が定義 | E-05（BlazorWebWasm セクション） | ○ |

## 4) 不足情報（Unknown / Missing）

すべての主張に対して根拠が確認できました。不足情報はありません。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張に根拠があり、ソースコードと整合しています

## 6) レビュアーチェックリスト（最小）

- [ ] Error.razor のコード内容が設計書の記述と一致しているか確認
- [ ] Activity.Current?.Id の取得が正しく機能するか確認
- [ ] 例外発生時のリダイレクトが正しく動作するか確認
