---
generated_at: 2026-01-30 12:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-Chat（WasmOnAspNetCore）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）

- E-01: `src/mono/wasm/testassets/WasmOnAspNetCore/BlazorClient/Pages/Chat.razor`（34行）
- E-02: `src/mono/wasm/testassets/WasmOnAspNetCore/Shared/SignalRTest.cs`（114行）
- E-03: `src/mono/wasm/testassets/WasmOnAspNetCore/Shared/TestOutput.cs`（20行）
- E-04: `src/mono/wasm/testassets/WasmOnAspNetCore/AspNetCoreServer/ChatHub.cs`（16行）
- E-05: `src/mono/wasm/testassets/WasmOnAspNetCore/BlazorClient/Program.cs`（13行）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/` である | E-01（1行目: `@page "/"`） | ○ |
| C-02 | NavigationManager を inject | E-01（2行目: `@inject NavigationManager`） | ○ |
| C-03 | ページタイトルは "Chat Room" | E-01（4行目: `<h1>Chat Room</h1>`） | ○ |
| C-04 | SignalRTest クラスを使用 | E-01（6行目: `private SignalRTest signalRTest = new()`） | ○ |
| C-05 | ShouldRender をオーバーライド | E-01（10-15行目: `protected override bool ShouldRender()`） | ○ |
| C-06 | OnAfterRenderAsync で SignalR テストを開始 | E-01（17-32行目: `OnAfterRenderAsync`） | ○ |
| C-07 | テスト成功時は終了コード 0 | E-01（25行目: `WASM EXIT {result}`）, E-02（74行目: `SetResult(0)`) | ○ |
| C-08 | テスト失敗時は終了コード -1 | E-01（29行目: `WASM EXIT -1`） | ○ |
| C-09 | クエリパラメータ transport と message が必須 | E-02（19, 44-56行目: クエリパラメータ検証） | ○ |
| C-10 | WebSocket と Long Polling をサポート | E-02（82-92行目: `StringToTransportType()`) | ○ |
| C-11 | HubConnectionBuilder で接続を構築 | E-02（63-68行目: `new HubConnectionBuilder()`) | ○ |
| C-12 | ReceiveMessage イベントハンドラを登録 | E-02（70-75行目: `_hubConnection.On<string>("ReceiveMessage"`) | ○ |
| C-13 | SendAsync でメッセージを送信 | E-02（100行目: `_hubConnection.SendAsync("SendMessage"`) | ○ |
| C-14 | TestOutput.WriteLine でログ出力 | E-03（10-13行目: `Console.WriteLine("TestOutput -> " + message)`) | ○ |
| C-15 | ChatHub で "-pong" を付加して返送 | E-04（13-14行目: `string changedMessage = $"{message}-pong"`) | ○ |
| C-16 | Clients.All.SendAsync で全クライアントへ送信 | E-04（14行目: `await Clients.All.SendAsync`) | ○ |
| C-17 | タイムアウトは2分 | E-02（28-31行目: `TimeSpan.FromMinutes(2)`) | ○ |
| C-18 | 関連機能は Mono, WebSockets, WebAssembly Workload, Http | E-07（24行目: 画面No 24 のマッピング） | ○ |
| C-19 | 画面カテゴリは Blazor ページ | E-06（25行目: カテゴリ "Blazor ページ"） | ○ |
| C-20 | HttpClient をスコープドサービスとして登録 | E-05（11行目: `builder.Services.AddScoped`) | ○ |

## 4) 不足情報（Unknown / Missing）

すべての主張に対して根拠が確認できました。不足情報はありません。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張に根拠があり、ソースコードと整合しています

## 6) レビュアーチェックリスト（最小）

- [ ] Chat.razor と SignalRTest.cs のコード内容が設計書の記述と一致しているか確認
- [ ] SignalR 接続が WebSocket と Long Polling の両方で正しく動作するか確認
- [ ] サーバーサイド ChatHub との通信が正しく機能するか確認
- [ ] クエリパラメータ不足時のエラーハンドリングが正しく動作するか確認
