---
generated_at: 2026-01-30 12:10:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-Wasm Browser Threading Sample

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/mono/sample/wasm/browser-threads/wwwroot/index.html` (1-25行目)
- E-02: `src/mono/sample/wasm/browser-threads/wwwroot/main.js` (1-87行目)
- E-03: `src/mono/sample/wasm/browser-threads/Program.cs` (1-102行目)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (4行目)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (9-12行目)
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` (56-75行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面タイトルは「Wasm Browser Threading Sample」 | E-01: index.html 15行目 `<h3 id="header">Wasm Browser Threading Sample</h3>` | ○ |
| C-02 | N の入力フィールドがある（初期値29） | E-01: index.html 17行目 `<input type="number" id="inputN" value="29"` | ○ |
| C-03 | 進捗表示要素は font-size: 500% | E-01: index.html 21行目 `style="font-size: 500%"` | ○ |
| C-04 | jsThreadBlockingMode を WarnWhenBlockingWait に設定 | E-02: main.js 21行目 `jsThreadBlockingMode: "WarnWhenBlockingWait"` | ○ |
| C-05 | setModuleImports で updateProgress を公開 | E-02: main.js 25-32行目 | ○ |
| C-06 | setModuleImports で updateProgress2 を公開 | E-02: main.js 29行目 | ○ |
| C-07 | doSlowMath 後に setEditable(true) を呼び出し | E-02: main.js 37行目 | ○ |
| C-08 | 50ms 間隔でポーリング | E-02: main.js 52行目 `await delay(50)` | ○ |
| C-09 | exports.Sample.Test.Progress() でポーリング | E-02: main.js 53行目 | ○ |
| C-10 | アニメーション配列にサイコロ絵文字を使用 | E-03: Program.cs 20行目 `"\u2680", "\u2681", "\u2682", "\u2683", "\u2684", "\u2685"` | ○ |
| C-11 | Main で Timer スレッドを生成 | E-03: Program.cs 25行目 `Task.Delay(200)` | ○ |
| C-12 | Progress2 で Directory.GetCurrentDirectory() を呼び出し | E-03: Program.cs 44行目 | ○ |
| C-13 | Progress2 で later.Wait() を呼び出し | E-03: Program.cs 50行目 | ○ |
| C-14 | Progress で _animationCounter をインクリメント | E-03: Program.cs 58行目 | ○ |
| C-15 | Progress で _isRunning を返す | E-03: Program.cs 63行目 `return _isRunning` | ○ |
| C-16 | Fib で Task.Run を使用 | E-03: Program.cs 70行目 `return Task.Run(() => {...}` | ○ |
| C-17 | Fib で _isRunning フラグを設定 | E-03: Program.cs 71行目, 73行目 | ○ |
| C-18 | FibImpl で _callCounter をインクリメント | E-03: Program.cs 80行目 | ○ |
| C-19 | 1000 回ごとに AllocateGarbage を呼び出し | E-03: Program.cs 82-85行目 | ○ |
| C-20 | 500000 回ごとに GC.Collect を呼び出し | E-03: Program.cs 87-88行目 | ○ |
| C-21 | 再帰的フィボナッチ計算を実装 | E-03: Program.cs 90-92行目 | ○ |
| C-22 | AllocateGarbage で object[200] を生成 | E-03: Program.cs 98行目 | ○ |
| C-23 | JSImport で updateProgress を定義 | E-03: Program.cs 33-34行目 | ○ |
| C-24 | JSImport で updateProgress2 を定義 | E-03: Program.cs 36-37行目 | ○ |
| C-25 | 関連機能に System.Threading が含まれる | E-05: 画面機能マッピング.csv 10行目 | ○ |
| C-26 | 関連機能にガベージコレクターが含まれる | E-05: 画面機能マッピング.csv 12行目 | ○ |
| C-27 | 単一画面で他画面への遷移なし | E-06: 画面遷移図.md | ○ |
| C-28 | inputElement.addEventListener で change イベント監視 | E-02: main.js 38行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、高い信頼性

## 6) レビュアーチェックリスト（最小）
- [ ] マルチスレッド動作に必要な crossOriginIsolated の設定確認
- [ ] jsThreadBlockingMode の警告が期待通り出力されるか確認
- [ ] サイコロアニメーションが正しく表示されるか確認
- [ ] GC.Collect() の呼び出しタイミングが適切か確認
