---
generated_at: 2026-01-30 12:15:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-Wasm Browser Shutdown Sample

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/mono/sample/wasm/browser-shutdown/wwwroot/index.html` (1-25行目)
- E-02: `src/mono/sample/wasm/browser-shutdown/wwwroot/main.js` (1-87行目)
- E-03: `src/mono/sample/wasm/browser-shutdown/Program.cs` (1-51行目)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (5行目)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (13-15行目)
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` (56-75行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面タイトルは「Wasm Browser Shutdown Sample」 | E-01: index.html 15行目 `<h3 id="header">Wasm Browser Shutdown Sample</h3>` | ○ |
| C-02 | Throw Managed Exception ボタンが存在 | E-01: index.html 16行目 `<button id="throw-managed-exc">` | ○ |
| C-03 | Trigger Native Assert ボタンが存在 | E-01: index.html 17行目 `<button id="trigger-native-assert">` | ○ |
| C-04 | Trigger Environment.FailFast ボタンが存在 | E-01: index.html 18行目 `<button id="trigger-failfast">` | ○ |
| C-05 | Call Harmless JSExport ボタンが存在 | E-01: index.html 19行目 `<button id="call-jsexport">` | ○ |
| C-06 | Call exit ボタンが存在 | E-01: index.html 20行目 `<button id="call-exit">` | ○ |
| C-07 | Start Timer ボタンが存在 | E-01: index.html 21行目 `<button id="start-timer">` | ○ |
| C-08 | timer-value 要素が存在 | E-01: index.html 22行目 `<span id="timer-value"></span>` | ○ |
| C-09 | onConfigLoaded で throwError パラメータをチェック | E-02: main.js 17-21行目 | ○ |
| C-10 | timerTick で DOM を更新 | E-02: main.js 27-29行目 | ○ |
| C-11 | throw-managed-exc クリックで ThrowManagedException 呼び出し | E-02: main.js 41-47行目 | ○ |
| C-12 | trigger-failfast クリックで CallFailFast 呼び出し | E-02: main.js 49-56行目 | ○ |
| C-13 | start-timer クリックで StartTimer 呼び出し | E-02: main.js 57-63行目 | ○ |
| C-14 | trigger-native-assert クリックで setenv(null, null) 呼び出し | E-02: main.js 64-71行目 | ○ |
| C-15 | call-jsexport クリックで DoNothing 呼び出し | E-02: main.js 72-78行目 | ○ |
| C-16 | call-exit クリックで exit(7) 呼び出し | E-02: main.js 79-85行目 | ○ |
| C-17 | DoNothing で Console.WriteLine 出力 | E-03: Program.cs 20-21行目 | ○ |
| C-18 | ThrowManagedException で例外をスロー | E-03: Program.cs 25-26行目 | ○ |
| C-19 | 例外メッセージが設定されている | E-03: Program.cs 26行目 | ○ |
| C-20 | CallFailFast で Environment.FailFast 呼び出し | E-03: Program.cs 31-32行目 | ○ |
| C-21 | FailFast メッセージが設定されている | E-03: Program.cs 32行目 `"User requested FailFast"` | ○ |
| C-22 | TimerTick は JSImport で定義 | E-03: Program.cs 35-36行目 | ○ |
| C-23 | StartTimer で 1 秒間隔タイマーを作成 | E-03: Program.cs 42行目 `new System.Timers.Timer(1000)` | ○ |
| C-24 | タイマーは AutoReset = true | E-03: Program.cs 47行目 | ○ |
| C-25 | タイマーの Elapsed イベントで TimerTick を呼び出し | E-03: Program.cs 43-46行目 | ○ |
| C-26 | 単一画面で他画面への遷移なし | E-06: 画面遷移図.md | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、高い信頼性

## 6) レビュアーチェックリスト（最小）
- [ ] 各ボタンクリック時の動作が期待通りか確認
- [ ] FailFast 後のランタイム状態が適切に処理されているか確認
- [ ] タイマーが正しく 1 秒間隔で動作するか確認
- [ ] ?throwError=true パラメータでのエラー処理が正しいか確認
