---
generated_at: 2026-01-30 12:20:00
metrics:
  claims_total: 32
  claims_with_evidence: 32
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-Benchmark Sample

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：32 / 32、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/mono/sample/wasm/browser-bench/wwwroot/index.html` (1-20行目)
- E-02: `src/mono/sample/wasm/browser-bench/wwwroot/main.js` (1-240行目)
- E-03: `src/mono/sample/wasm/browser-bench/Program.cs` (1-277行目)
- E-04: `src/mono/sample/wasm/browser-bench/BenchTask.cs` (1-137行目)
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` (6行目)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (16-21行目)
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md` (56-75行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面タイトルは「Wasm Browser Sample - Simple Benchmark」 | E-01: index.html 16行目 | ○ |
| C-02 | style.css を参照 | E-01: index.html 11行目 `<link rel="stylesheet" href="style.css">` | ○ |
| C-03 | --jiterpreter-stats-enabled オプションを設定 | E-02: main.js 231行目 `.withRuntimeOptions(["--jiterpreter-stats-enabled"])` | ○ |
| C-04 | MainApp クラスを定義 | E-02: main.js 49行目 `class MainApp` | ○ |
| C-05 | init メソッドでベンチマーク初期化 | E-02: main.js 50-131行目 | ○ |
| C-06 | URL パラメータから task を取得 | E-02: main.js 79行目 `url.searchParams.getAll('task')` | ○ |
| C-07 | URL パラメータから exclusions を取得 | E-02: main.js 83行目 `url.searchParams.getAll('exclusions')` | ○ |
| C-08 | /rewrite=bootstrap.flag に POST 送信 | E-02: main.js 88-92行目 | ○ |
| C-09 | yieldBench でタスク実行 | E-02: main.js 133-135行目 | ○ |
| C-10 | /log=bench-log.txt に POST 送信 | E-02: main.js 99-102行目 | ○ |
| C-11 | /rewrite=results.json に POST 送信 | E-02: main.js 106-110行目 | ○ |
| C-12 | /rewrite=results.html に POST 送信 | E-02: main.js 111-115行目 | ○ |
| C-13 | _jiterpreter_dump_stats を呼び出し | E-02: main.js 121-122行目 | ○ |
| C-14 | _interp_pgo_save_data を呼び出し | E-02: main.js 129-130行目 | ○ |
| C-15 | タスク一覧に AppStartTask が含まれる | E-03: Program.cs 25行目 | ○ |
| C-16 | タスク一覧に ExceptionsTask が含まれる | E-03: Program.cs 26行目 | ○ |
| C-17 | タスク一覧に JsonTask が含まれる | E-03: Program.cs 27行目 | ○ |
| C-18 | タスク一覧に SpanTask が含まれる | E-03: Program.cs 28行目 | ○ |
| C-19 | タスク一覧に StringTask が含まれる | E-03: Program.cs 29行目 | ○ |
| C-20 | タスク一覧に VectorTask が含まれる | E-03: Program.cs 30行目 | ○ |
| C-21 | タスク一覧に JSInteropTask が含まれる | E-03: Program.cs 31行目 | ○ |
| C-22 | タスク一覧に WebSocketTask が含まれる | E-03: Program.cs 32行目 | ○ |
| C-23 | RunBenchmark は JSExport で公開 | E-03: Program.cs 37-41行目 | ○ |
| C-24 | SetExclusions は JSExport で公開 | E-03: Program.cs 43-50行目 | ○ |
| C-25 | SetTasks は JSExport で公開 | E-03: Program.cs 54-88行目 | ○ |
| C-26 | GetFullJsonResults は JSExport で公開 | E-03: Program.cs 90-94行目 | ○ |
| C-27 | BenchTask.Result に span フィールドがある | E-04: BenchTask.cs 37行目 | ○ |
| C-28 | BenchTask.Result に steps フィールドがある | E-04: BenchTask.cs 38行目 | ○ |
| C-29 | Measurement.InitialSamples のデフォルトは 10 | E-04: BenchTask.cs 49行目 | ○ |
| C-30 | Measurement.NumberOfRuns のデフォルトは 5 | E-04: BenchTask.cs 50行目 | ○ |
| C-31 | Measurement.RunLength のデフォルトは 5000 | E-04: BenchTask.cs 51行目 | ○ |
| C-32 | 単一画面で他画面への遷移なし | E-07: 画面遷移図.md | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、高い信頼性

## 6) レビュアーチェックリスト（最小）
- [ ] ベンチマークサーバーの POST エンドポイントが正しく設定されているか確認
- [ ] Jiterpreter 統計出力が期待通りに動作するか確認
- [ ] 各ベンチマークタスクが正しく実行されるか確認
- [ ] URL パラメータによるタスク指定と除外が正しく動作するか確認
