---
generated_at: 2026-01-30 12:25:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-Profiler Sample

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/mono/sample/wasm/browser-profile/wwwroot/index.html` (1-19行目)
- E-02: `src/mono/sample/wasm/browser-profile/wwwroot/main.js` (1-49行目)
- E-03: `src/mono/sample/wasm/browser-profile/Program.cs` (1-26行目)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (7行目)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (22-24行目)
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` (56-75行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面タイトルは「Wasm Profiler Sample」 | E-01: index.html 15行目 `<h3 id="header">Wasm Profiler Sample</h3>` | ○ |
| C-02 | TestMeaning の結果を表示 | E-01: index.html 16行目 `Result from Sample.Test.TestMeaning: <span id="out">` | ○ |
| C-03 | saveProfile 関数でプロファイルデータを保存 | E-02: main.js 6-20行目 | ○ |
| C-04 | aotProfileData が未設定の場合エラーをスロー | E-02: main.js 7-9行目 | ○ |
| C-05 | ダウンロードファイル名は "data.aotprofile" | E-02: main.js 13行目 `a.download = "data.aotprofile"` | ○ |
| C-06 | aotProfilerOptions.writeAt を設定 | E-02: main.js 27行目 `writeAt: "Sample.Test::StopProfile"` | ○ |
| C-07 | aotProfilerOptions.sendTo を設定 | E-02: main.js 28行目 | ○ |
| C-08 | "not ready yet" をコンソール出力 | E-02: main.js 33行目 | ○ |
| C-09 | "ready" をコンソール出力 | E-02: main.js 37行目 | ○ |
| C-10 | testMeaning() を呼び出して結果を取得 | E-02: main.js 38行目 | ○ |
| C-11 | DOM に結果を表示 | E-02: main.js 39行目 | ○ |
| C-12 | stopProfile() を呼び出し | E-02: main.js 42行目 | ○ |
| C-13 | INTERNAL.aotProfileData を saveProfile に渡す | E-02: main.js 43行目 | ○ |
| C-14 | 結果が 42 の場合は終了コード 0 | E-02: main.js 45行目 | ○ |
| C-15 | Main で "Hello, World!" を出力 | E-03: Program.cs 14行目 | ○ |
| C-16 | TestMeaning は JSExport で公開 | E-03: Program.cs 17-21行目 | ○ |
| C-17 | TestMeaning は 42 を返す | E-03: Program.cs 20行目 `return 42` | ○ |
| C-18 | StopProfile は JSExport で公開 | E-03: Program.cs 23-24行目 | ○ |
| C-19 | StopProfile は空実装 | E-03: Program.cs 24行目 `public static void StopProfile(){}` | ○ |
| C-20 | 関連機能に Mono が含まれる | E-05: 画面機能マッピング.csv 22行目 | ○ |
| C-21 | 関連機能に eventpipe が含まれる | E-05: 画面機能マッピング.csv 24行目 | ○ |
| C-22 | 単一画面で他画面への遷移なし | E-06: 画面遷移図.md | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、高い信頼性

## 6) レビュアーチェックリスト（最小）
- [ ] AOT プロファイルデータが正しく生成されるか確認
- [ ] ダウンロードされた .aotprofile ファイルが有効か確認
- [ ] StopProfile 呼び出し時にプロファイリングが正しく停止するか確認
