---
generated_at: 2026-01-30 12:30:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-Log Profiler Sample

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/mono/sample/wasm/browser-logprofile/wwwroot/index.html` (1-19行目)
- E-02: `src/mono/sample/wasm/browser-logprofile/wwwroot/main.js` (1-67行目)
- E-03: `src/mono/sample/wasm/browser-logprofile/Program.cs` (1-31行目)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (8行目)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (25-28行目)
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` (56-75行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面タイトルは「Wasm Log Profiler Sample」 | E-01: index.html 15行目 `<h3 id="header">Wasm Log Profiler Sample</h3>` | ○ |
| C-02 | TestMeaning の結果を表示 | E-01: index.html 16行目 | ○ |
| C-03 | saveProfile 関数でプロファイルデータを保存 | E-02: main.js 6-19行目 | ○ |
| C-04 | readProfileFile で output.mlpd を読み取り | E-02: main.js 21-33行目 | ○ |
| C-05 | Module.FS.stat でファイルサイズ確認 | E-02: main.js 24行目 | ○ |
| C-06 | Module.FS.readFile でファイル読み取り | E-02: main.js 27行目 | ○ |
| C-07 | ダウンロードファイル名は "output.mlpd" | E-02: main.js 13行目 | ○ |
| C-08 | logProfilerOptions.takeHeapshot を設定 | E-02: main.js 42行目 | ○ |
| C-09 | logProfilerOptions.configuration を設定 | E-02: main.js 43行目 `"log:alloc,output=output.mlpd"` | ○ |
| C-10 | dotnet.run() を呼び出し | E-02: main.js 54行目 | ○ |
| C-11 | "not ready yet" をコンソール出力 | E-02: main.js 48行目 | ○ |
| C-12 | "ready" をコンソール出力 | E-02: main.js 52行目 | ○ |
| C-13 | testMeaning() を呼び出して結果を取得 | E-02: main.js 56行目 | ○ |
| C-14 | DOM に結果を表示 | E-02: main.js 57行目 | ○ |
| C-15 | takeHeapshot() を呼び出し | E-02: main.js 60行目 | ○ |
| C-16 | saveProfile(Module) を呼び出し | E-02: main.js 61行目 | ○ |
| C-17 | Main で "Hello, World!" を出力 | E-03: Program.cs 14行目 | ○ |
| C-18 | TakeHeapshot は JSExport で公開 | E-03: Program.cs 17-19行目 | ○ |
| C-19 | TakeHeapshot は NoInlining 属性付き | E-03: Program.cs 18行目 | ○ |
| C-20 | TestMeaning は JSExport で公開 | E-03: Program.cs 21-29行目 | ○ |
| C-21 | TestMeaning で 100 回ループで int[1000] を生成 | E-03: Program.cs 24-26行目 | ○ |
| C-22 | TestMeaning は 42 を返す | E-03: Program.cs 28行目 | ○ |
| C-23 | 関連機能にガベージコレクターが含まれる | E-05: 画面機能マッピング.csv 28行目 | ○ |
| C-24 | 単一画面で他画面への遷移なし | E-06: 画面遷移図.md | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、高い信頼性

## 6) レビュアーチェックリスト（最小）
- [ ] ログプロファイルデータが正しく生成されるか確認
- [ ] ダウンロードされた .mlpd ファイルが有効か確認（mprof-report で解析可能か）
- [ ] TakeHeapshot 呼び出し時にヒープショットが正しく取得されるか確認
- [ ] メモリアロケーションが正しく記録されているか確認
