---
generated_at: 2026-01-30 12:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-EventPipe Profiling Sample

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/mono/sample/wasm/browser-eventpipe/wwwroot/index.html` (1-26行目)
- E-02: `src/mono/sample/wasm/browser-eventpipe/wwwroot/main.js` (1-65行目)
- E-03: `src/mono/sample/wasm/browser-eventpipe/Program.cs` (1-161行目)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (9行目)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (29-32行目)
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` (56-75行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面タイトルは「Wasm Browser EventPipe profiling Sample」 | E-01: index.html 15行目 | ○ |
| C-02 | Say Hi ボタンが存在 | E-01: index.html 19行目 `<button id="hello-button">Say Hi</button>` | ○ |
| C-03 | Answer to the Ultimate Question を表示 | E-01: index.html 23行目 | ○ |
| C-04 | displayMeaning 関数で DOM 更新 | E-02: main.js 6-8行目 | ○ |
| C-05 | setModuleImports で displayMeaning を公開 | E-02: main.js 33-39行目 | ○ |
| C-06 | hello-button にクリックイベント登録 | E-02: main.js 45-51行目 | ○ |
| C-07 | クリック時に sayHi() を呼び出し | E-02: main.js 47行目 | ○ |
| C-08 | runMain() を呼び出し | E-02: main.js 53行目 | ○ |
| C-09 | 初期化後に sayHi() を呼び出し | E-02: main.js 55行目 | ○ |
| C-10 | ConsoleWriterEventListener クラスが定義されている | E-03: Program.cs 14-34行目 | ○ |
| C-11 | OnEventSourceCreated で WasmHello イベントソースを有効化 | E-03: Program.cs 18-27行目 | ○ |
| C-12 | OnEventWritten でタイムスタンプとイベント名を出力 | E-03: Program.cs 30-33行目 | ○ |
| C-13 | Main で DisplayMeaning(42) を呼び出し | E-03: Program.cs 40行目 | ○ |
| C-14 | Main で NewCallsCounter() を呼び出し | E-03: Program.cs 42行目 | ○ |
| C-15 | Main で ConsoleWriterEventListener を作成 | E-03: Program.cs 43行目 | ○ |
| C-16 | SayHi は JSExport で公開 | E-03: Program.cs 54-69行目 | ○ |
| C-17 | SayHi で "Hi from C#!" を出力 | E-03: Program.cs 58行目 | ○ |
| C-18 | SayHi で HelloStart イベントを発行 | E-03: Program.cs 59行目 | ○ |
| C-19 | SayHi で CountCall を 100,000 回呼び出し | E-03: Program.cs 61-64行目 | ○ |
| C-20 | SayHi で SayHiCatch を呼び出し | E-03: Program.cs 66行目 | ○ |
| C-21 | SayHi で HelloStop イベントを発行 | E-03: Program.cs 67行目 | ○ |
| C-22 | SayHi で "Bye from C#!" を出力 | E-03: Program.cs 68行目 | ○ |
| C-23 | SayHiThrow で例外をスロー | E-03: Program.cs 72-74行目 | ○ |
| C-24 | SayHiCatch で例外をキャッチ | E-03: Program.cs 77-88行目 | ○ |
| C-25 | WasmHelloEventSource の Name は "WasmHello" | E-03: Program.cs 109行目 | ○ |
| C-26 | HelloStart は Event ID 1 | E-03: Program.cs 143行目 `[Event(1, ...)]` | ○ |
| C-27 | HelloStop は Event ID 2 | E-03: Program.cs 152行目 `[Event(2, ...)]` | ○ |
| C-28 | 単一画面で他画面への遷移なし | E-06: 画面遷移図.md | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、高い信頼性

## 6) レビュアーチェックリスト（最小）
- [ ] EventSource イベントがコンソールに正しく出力されるか確認
- [ ] IncrementingEventCounter が正しくカウントされるか確認
- [ ] Say Hi ボタンクリックで期待通りの動作をするか確認
- [ ] EventLevel.Informational でイベントが有効になっているか確認
