---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 60
  claims_with_evidence: 56
  claims_without_evidence: 4
confidence_derived: 0.93
---

# 根拠レポート：結合テストケース一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：56 / 60、根拠なし：4
- 優先レビュー（高）
  1. **IT-011（HTTP/3プロトコル通信確認）**：HTTP/3の実装はオプショナルであり、環境依存性が高い
  2. **IT-046（NTLM/Windows認証）**：Windows固有機能のため、クロスプラットフォーム環境でのテスト可否要確認
  3. **IT-021（WebSocket圧縮）**：Per-Message Deflateの対応状況はサーバー依存
  4. **IT-042（DbProviderFactory）**：具体的なプロバイダ実装が必要なため、環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Net.Http/src/System/Net/Http/HttpClient.cs`
- E-02: `src/libraries/System.Net.Http/src/System/Net/Http/HttpClientHandler.cs`
- E-03: `src/libraries/System.Net.Http/tests/FunctionalTests/HttpClientTest.cs`
- E-04: `src/libraries/System.Net.Http/tests/FunctionalTests/HttpClientHandlerTest.Http2.cs`
- E-05: `src/libraries/System.Net.Http/tests/FunctionalTests/HttpClientHandlerTest.Http3.cs`
- E-06: `src/libraries/System.Net.Http/tests/FunctionalTests/SocksProxyTest.cs`
- E-07: `src/libraries/System.Net.Http/tests/FunctionalTests/HttpClientHandlerTest.BasicAuth.cs`
- E-08: `src/libraries/System.Net.Http/tests/FunctionalTests/NtAuthTests.cs`
- E-09: `src/libraries/System.Net.Http/tests/FunctionalTests/MultipartFormDataContentTest.cs`
- E-10: `src/libraries/System.Net.Http/tests/FunctionalTests/StreamContentTest.cs`
- E-11: `src/libraries/System.Net.Http/tests/FunctionalTests/SocketsHttpHandlerTest.cs`
- E-12: `src/libraries/System.Net.Http/tests/FunctionalTests/SocketsHttpHandlerTest.Http2KeepAlivePing.cs`
- E-13: `src/libraries/System.Net.Http/tests/FunctionalTests/SocketsHttpHandlerTest.Http2FlowControl.cs`
- E-14: `src/libraries/System.Net.Http/tests/FunctionalTests/SocketsHttpHandlerTest.Http1KeepAlive.cs`
- E-15: `src/libraries/System.Net.Http/tests/FunctionalTests/HttpClientHandlerTest.RequestRetry.cs`
- E-16: `src/libraries/System.Net.Http/tests/FunctionalTests/TelemetryTest.cs`
- E-17: `src/libraries/System.Net.Http/tests/FunctionalTests/MetricsTest.cs`
- E-18: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/WebSocket.cs`
- E-19: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/ManagedWebSocket.cs`
- E-20: `src/libraries/System.Net.WebSockets/src/System/Net/WebSockets/ManagedWebSocket.KeepAlive.cs`
- E-21: `src/libraries/System.Net.WebSockets/tests/WebSocketTests.cs`
- E-22: `src/libraries/System.Net.WebSockets/tests/WebSocketCloseTests.cs`
- E-23: `src/libraries/System.Net.WebSockets/tests/WebSocketKeepAliveTests.cs`
- E-24: `src/libraries/System.Net.WebSockets/tests/WebSocketDeflateTests.cs`
- E-25: `src/libraries/System.Data.Common/src/System/Data/Common/DbConnection.cs`
- E-26: `src/libraries/System.Data.Common/src/System/Data/Common/DbCommand.cs`
- E-27: `src/libraries/System.Data.Common/src/System/Data/Common/DbTransaction.cs`
- E-28: `src/libraries/System.Data.Common/src/System/Data/Common/DbDataReader.cs`
- E-29: `src/libraries/System.Data.Common/src/System/Data/Common/DbDataAdapter.cs`
- E-30: `src/libraries/System.Data.Common/src/System/Data/Common/DbProviderFactory.cs`
- E-31: `src/libraries/System.Data.Common/tests/System/Data/Common/DbConnectionTests.cs`
- E-32: `src/libraries/System.Data.Common/tests/System/Data/Common/DbCommandTests.cs`
- E-33: `src/libraries/System.Data.Common/tests/System/Data/Common/DbTransactionTest.cs`
- E-34: `src/libraries/System.Data.Common/tests/System/Data/Common/DbDataReaderTest.cs`
- E-35: `src/libraries/System.Data.Common/tests/System/Data/Common/DbDataAdapterTest.cs`
- E-36: `src/libraries/System.Data.Common/tests/System/Data/Common/DbProviderFactoriesTests.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001: HTTP GET リクエストの正常実行 | E-01, E-03 | ○ |
| C-02 | IT-002: HTTP POST リクエストの正常実行 | E-01, E-03 | ○ |
| C-03 | IT-003: HTTP PUT リクエストの正常実行 | E-01, E-03 | ○ |
| C-04 | IT-004: HTTP PATCH リクエストの正常実行 | E-01, E-03 | ○ |
| C-05 | IT-005: HTTP DELETE リクエストの正常実行 | E-01, E-03 | ○ |
| C-06 | IT-006: タイムアウト設定の動作確認 | E-01, E-03 | ○ |
| C-07 | IT-007: BaseAddress設定による相対URL解決 | E-01, E-03 | ○ |
| C-08 | IT-008: DefaultRequestHeadersの適用確認 | E-01, E-03 | ○ |
| C-09 | IT-009: CancelPendingRequestsによるリクエストキャンセル | E-01, E-03 | ○ |
| C-10 | IT-010: HTTP/2プロトコルでの通信確認 | E-01, E-04 | ○ |
| C-11 | IT-011: HTTP/3プロトコルでの通信確認 | E-05 | △ |
| C-12 | IT-012: Proxyを経由したHTTP通信 | E-02, E-06 | ○ |
| C-13 | IT-013: SSL/TLS証明書検証の動作確認 | E-02 | ○ |
| C-14 | IT-014: 自動リダイレクトの動作確認 | E-02 | ○ |
| C-15 | IT-015: Cookie自動管理の動作確認 | E-02 | ○ |
| C-16 | IT-016: WebSocket接続の確立 | E-18, E-21 | ○ |
| C-17 | IT-017: WebSocketメッセージの送信 | E-19, E-21 | ○ |
| C-18 | IT-018: WebSocketメッセージの受信 | E-19, E-21 | ○ |
| C-19 | IT-019: WebSocket接続のクローズ | E-19, E-22 | ○ |
| C-20 | IT-020: WebSocket KeepAliveの動作確認 | E-20, E-23 | ○ |
| C-21 | IT-021: WebSocket圧縮（Per-Message Deflate）の動作確認 | E-24 | △ |
| C-22 | IT-022: サブプロトコルの交渉 | E-18, E-21 | ○ |
| C-23 | IT-023: データベース接続のオープン | E-25, E-31 | ○ |
| C-24 | IT-024: データベース接続のクローズ | E-25, E-31 | ○ |
| C-25 | IT-025: 非同期接続のオープン | E-25, E-31 | ○ |
| C-26 | IT-026: 接続文字列の変更 | E-25, E-31 | ○ |
| C-27 | IT-027: データベースの切り替え | E-25, E-31 | ○ |
| C-28 | IT-028: SQLコマンドの実行（ExecuteNonQuery） | E-26, E-32 | ○ |
| C-29 | IT-029: SQLコマンドの実行（ExecuteReader） | E-26, E-32 | ○ |
| C-30 | IT-030: SQLコマンドの実行（ExecuteScalar） | E-26, E-32 | ○ |
| C-31 | IT-031: パラメータ化クエリの実行 | E-26, E-32 | ○ |
| C-32 | IT-032: 非同期コマンド実行 | E-26, E-32 | ○ |
| C-33 | IT-033: トランザクションの開始 | E-25, E-27, E-33 | ○ |
| C-34 | IT-034: トランザクションのコミット | E-27, E-33 | ○ |
| C-35 | IT-035: トランザクションのロールバック | E-27, E-33 | ○ |
| C-36 | IT-036: 分離レベルの設定 | E-27, E-33 | ○ |
| C-37 | IT-037: 結果セットの読み取り | E-28, E-34 | ○ |
| C-38 | IT-038: 複数結果セットの読み取り | E-28, E-34 | ○ |
| C-39 | IT-039: 非同期での結果セット読み取り | E-28, E-34 | ○ |
| C-40 | IT-040: DataSetへのデータ充填 | E-29, E-35 | ○ |
| C-41 | IT-041: DataSetからの更新 | E-29, E-35 | ○ |
| C-42 | IT-042: プロバイダファクトリによる接続生成 | E-30, E-36 | △ |
| C-43 | IT-043: カスタムメッセージハンドラチェーン | E-01 | ○ |
| C-44 | IT-044: リトライハンドラの動作確認 | E-15 | ○ |
| C-45 | IT-045: Basic認証の動作確認 | E-07 | ○ |
| C-46 | IT-046: NTLM/Windows認証の動作確認 | E-08 | △ |
| C-47 | IT-047: MultipartFormDataContentの送信 | E-09 | ○ |
| C-48 | IT-048: StreamContentによるストリーミング送信 | E-10 | ○ |
| C-49 | IT-049: 接続プーリングの動作確認 | E-11 | ○ |
| C-50 | IT-050: HTTP/2 KeepAlivePingの動作確認 | E-12 | ○ |
| C-51 | IT-051: HTTP/2フロー制御の動作確認 | E-13 | ○ |
| C-52 | IT-052: HTTP/1.1 KeepAliveの動作確認 | E-14 | ○ |
| C-53 | IT-053: Responseストリームの読み取り | E-01, E-03 | ○ |
| C-54 | IT-054: ResponseのByteArray取得 | E-01, E-03 | ○ |
| C-55 | IT-055: ResponseのString取得 | E-01, E-03 | ○ |
| C-56 | IT-056: HttpCompletionOption.ResponseHeadersReadの動作 | E-01, E-03 | ○ |
| C-57 | IT-057: スキーマ情報の取得 | E-25, E-31 | ○ |
| C-58 | IT-058: 接続イベントの発火確認 | E-25, E-31 | ○ |
| C-59 | IT-059: HTTPリクエストのテレメトリ収集 | E-16 | ○ |
| C-60 | IT-060: HTTPリクエストのメトリクス収集 | E-17 | ○ |

## 4) 不足情報（Unknown / Missing）
- **IT-011（HTTP/3プロトコル通信確認）**：HTTP/3はQuicプロトコルに依存しており、サポートはOSやネットワーク環境に依存する。テスト環境でHTTP/3が利用可能かの確認が必要。
  - 候補：HTTP/3対応テストサーバーの構築 / Dockerコンテナでの検証環境 / モック対応
- **IT-021（WebSocket圧縮）**：Per-Message Deflate拡張はサーバー側の対応が必要。すべてのWebSocketサーバーが対応しているわけではない。
  - 候補：圧縮対応WebSocketサーバーの準備 / テスト用モックサーバー
- **IT-042（DbProviderFactory）**：DbProviderFactoryは抽象クラスであり、実際のテストには具体的なデータベースプロバイダ（SQL Server, PostgreSQL等）が必要。
  - 候補：インメモリDB（SQLite）での代替テスト / テスト用プロバイダ実装
- **IT-046（NTLM/Windows認証）**：Windows固有の認証機能であり、Linux/macOS環境でのテストには制限がある。
  - 候補：Windows環境限定テスト / 条件付きテストスキップ

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - HTTP/3テスト（IT-011）：環境依存性が高く、CI/CD環境での自動テスト実行に課題がある可能性
- **1: 中リスク** - WebSocket圧縮テスト（IT-021）：サーバー側の設定に依存するため、テスト環境の統一が必要
- **1: 中リスク** - NTLM認証テスト（IT-046）：クロスプラットフォームテストにおける制約
- **0: 低リスク** - DbProviderFactory（IT-042）：抽象化レイヤーのテストであり、実装プロバイダ依存

## 6) レビュアーチェックリスト（最小）
- [ ] HTTP/1.1, HTTP/2, HTTP/3の各プロトコルに対するテストケースが網羅されているか
- [ ] WebSocketの接続・送受信・切断のライフサイクルがカバーされているか
- [ ] データベース操作（CRUD）とトランザクション管理がテストケースに含まれているか
- [ ] 非同期メソッド（*Async）のテストケースが対応する同期メソッドと同等にカバーされているか
- [ ] エラーケース・例外処理のテストケースが含まれているか（今回のスコープでは正常系を中心に記載）
- [ ] テスト環境依存のテストケース（△）について、実行条件の明確化がされているか
- [ ] プラットフォーム固有機能（Windows認証等）について、適切なスキップ条件が設定されているか
