---
generated_at: 2026-01-30 11:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - なし（すべての項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.ObjectModel/src/System/ComponentModel/INotifyPropertyChanged.cs`
- E-02: `src/libraries/System.ObjectModel/src/System/ComponentModel/INotifyPropertyChanging.cs`
- E-03: `src/libraries/System.ObjectModel/src/System/ComponentModel/INotifyDataErrorInfo.cs`
- E-04: `src/libraries/System.ObjectModel/src/System/Collections/Specialized/INotifyCollectionChanged.cs`
- E-05: `src/libraries/System.ObjectModel/src/System/Collections/ObjectModel/ObservableCollection.cs`
- E-06: `src/libraries/System.Private.CoreLib/src/System/Runtime/CompilerServices/INotifyCompletion.cs`
- E-07: `src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Hosting/INotifyComposablePartCatalogChanged.cs`
- E-08: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs`
- E-09: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemEventArgs.cs`
- E-10: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/RenamedEventArgs.cs`
- E-11: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/ErrorEventArgs.cs`
- E-12: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/WatcherChangeTypes.cs`
- E-13: `src/libraries/Common/src/Interop/Linux/System.Native/Interop.INotify.cs`
- E-14: `src/libraries/System.Net.Mail/src/System/Net/Mail/SmtpClient.cs`
- E-15: `src/libraries/System.Speech/src/Internal/SapiInterop/EventNotify.cs`
- E-16: `src/libraries/System.ObjectModel/src/System/ComponentModel/PropertyChangedEventArgs.cs`
- E-17: `src/libraries/System.ObjectModel/src/System/ComponentModel/PropertyChangedEventHandler.cs`
- E-18: `src/libraries/System.ObjectModel/src/System/ComponentModel/PropertyChangingEventArgs.cs`
- E-19: `src/libraries/System.ObjectModel/src/System/ComponentModel/DataErrorsChangedEventArgs.cs`
- E-20: `src/libraries/System.ObjectModel/src/System/Collections/Specialized/NotifyCollectionChangedEventArgs.cs`
- E-21: `src/libraries/System.ObjectModel/src/System/Collections/Specialized/NotifyCollectionChangedAction.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | INotifyPropertyChanged.PropertyChanged: オブジェクトのプロパティが変更された際に発生するイベント | E-01, E-16, E-17 | ○ |
| C-02 | INotifyPropertyChanging.PropertyChanging: プロパティ変更直前に発生するイベント | E-02, E-18 | ○ |
| C-03 | INotifyDataErrorInfo.ErrorsChanged: データ検証エラー状態変化時のイベント | E-03, E-19 | ○ |
| C-04 | INotifyCollectionChanged.CollectionChanged: コレクション変更時のイベント | E-04, E-20, E-21 | ○ |
| C-05 | ObservableCollection<T>.CollectionChanged: 動的データコレクション変更監視 | E-05, E-04 | ○ |
| C-06 | INotifyCompletion.OnCompleted: 非同期完了時の継続処理スケジュール | E-06 | ○ |
| C-07 | ICriticalNotifyCompletion.UnsafeOnCompleted: ExecutionContext非伝播の継続処理 | E-06 | ○ |
| C-08 | INotifyComposablePartCatalogChanged.Changed: MEFカタログ変更後のイベント | E-07 | ○ |
| C-09 | INotifyComposablePartCatalogChanged.Changing: MEFカタログ変更直前のイベント | E-07 | ○ |
| C-10 | FileSystemWatcher.Changed: ファイル/ディレクトリ変更時のイベント | E-08, E-09 | ○ |
| C-11 | FileSystemWatcher.Created: ファイル/ディレクトリ作成時のイベント | E-08, E-09 | ○ |
| C-12 | FileSystemWatcher.Deleted: ファイル/ディレクトリ削除時のイベント | E-08, E-09 | ○ |
| C-13 | FileSystemWatcher.Renamed: ファイル/ディレクトリ名前変更時のイベント | E-08, E-10 | ○ |
| C-14 | FileSystemWatcher.Error: バッファオーバーフロー等のエラーイベント | E-08, E-11 | ○ |
| C-15 | IN_ACCESS: ファイルアクセス時のLinux inotify通知 | E-13 | ○ |
| C-16 | IN_MODIFY: ファイル変更時のLinux inotify通知 | E-13 | ○ |
| C-17 | IN_ATTRIB: 属性変更時のLinux inotify通知 | E-13 | ○ |
| C-18 | IN_MOVED_FROM: ファイル移動元のLinux inotify通知 | E-13 | ○ |
| C-19 | IN_MOVED_TO: ファイル移動先のLinux inotify通知 | E-13 | ○ |
| C-20 | IN_CREATE: ファイル作成時のLinux inotify通知 | E-13 | ○ |
| C-21 | IN_DELETE: ファイル削除時のLinux inotify通知 | E-13 | ○ |
| C-22 | IN_Q_OVERFLOW: キューオーバーフロー時のLinux inotify通知 | E-13 | ○ |
| C-23 | IN_IGNORED: 監視削除時のLinux inotify通知 | E-13 | ○ |
| C-24 | SmtpClient.SendCompleted: 非同期メール送信完了時のイベント | E-14 | ○ |
| C-25 | EventNotify.SendNotification: SAPI音声認識イベントディスパッチ | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての通知機能について、ソースコードから直接根拠を確認済み。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての項目がソースコードで確認済み
- 注記: EventNotify（C-25）は内部クラスのため、公開APIとしてはドキュメント化されていない可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] 各通知インターフェース/イベントの説明がソースコードのXMLドキュメントと一致しているか確認
- [ ] 名前空間の記載が正確か確認
- [ ] Linux inotify通知がLinuxプラットフォーム専用である旨が明記されているか確認
- [ ] 内部クラス（EventNotify）を一覧に含めるべきか検討
- [ ] プロジェクトの対象範囲に含まれない通知機能がないか確認
