# 通知設計書 19-Interop.Sys.INotify (IN_MOVED_TO)

## 概要

本ドキュメントは、Linux の inotify サブシステムが提供する `IN_MOVED_TO` 通知について、.NET ランタイムでの実装詳細と設計仕様を記述した通知設計書である。

### 本通知の処理概要

IN_MOVED_TO は、ファイルまたはディレクトリが監視対象ディレクトリに移動された（移動先として検出された）際に Linux カーネルの inotify サブシステムが生成する通知イベントである。.NET の FileSystemWatcher では、IN_MOVED_FROM とペアになった場合は Renamed イベントに、単独の場合は Created イベントに変換される。

**業務上の目的・背景**：ファイルの移動検知は、ファイル同期システム、バージョン管理、ファイル追跡、監査ログの記録など、多くの業務シナリオで必要とされる。IN_MOVED_TO は IN_MOVED_FROM と組み合わせてファイルリネーム（移動）を検知するために使用され、cookie 値によってペアが関連付けられる。

**通知の送信タイミング**：監視対象ディレクトリ内にファイルまたはディレクトリが rename() システムコールで移動（リネーム）された際に、カーネルが移動先に対して IN_MOVED_TO イベントを生成する。このイベントは .NET の FileSystemWatcher.Linux 実装で処理される。

**通知の受信者**：FileSystemWatcher インスタンスの Renamed または Created イベントにハンドラを登録したアプリケーションコード。NotifyFilters に FileName または DirectoryName が含まれている必要がある。

**通知内容の概要**：inotify イベントとして、ウォッチ記述子（wd）、イベントマスク（IN_MOVED_TO）、cookie（ペア関連付け用）、ファイル名（name）が通知される。対応する IN_MOVED_FROM が存在する場合は Renamed イベント、存在しない場合は Created イベントとしてアプリケーションに伝達される。

**期待されるアクション**：受信者は通知を受け取り後、ファイル追跡の更新、同期先でのリネーム処理、監査ログの記録、キャッシュの更新などの処理を実行することが期待される。

## 通知種別

OSカーネル通知（inotify イベント）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（カーネルからの割り込み） |
| 優先度 | 通常（他の inotify イベントと同等） |
| リトライ | なし（カーネルは一度のみ通知） |

### 送信先決定ロジック

inotify_add_watch() で登録されたウォッチ記述子に対応する inotify ファイルディスクリプタに対してイベントが送信される。IN_MOVED_TO は IN_MOVED_FROM とペアになる可能性があり、cookie 値で関連付けられる。

## 通知テンプレート

### inotify イベント構造

| 項目 | 内容 |
|-----|------|
| イベント型 | struct inotify_event |
| マスク値 | IN_MOVED_TO (0x00000080) |
| cookie | ペア関連付け用の一意な値（0以外） |

### イベントデータ構造

```c
struct inotify_event {
    int      wd;       // ウォッチ記述子
    uint32_t mask;     // IN_MOVED_TO = 0x00000080
    uint32_t cookie;   // IN_MOVED_FROM との関連付け用
    uint32_t len;      // name の長さ
    char     name[];   // 移動先のファイル名（NULL終端）
};
```

### .NET での変換後

```csharp
// IN_MOVED_FROM + IN_MOVED_TO ペアの場合
RenamedEventArgs {
    ChangeType = WatcherChangeTypes.Renamed,
    FullPath = "新しいパス",        // IN_MOVED_TO の情報
    Name = "新しい名前",           // IN_MOVED_TO の name
    OldFullPath = "古いパス",
    OldName = "古い名前"
}

// IN_MOVED_TO 単独の場合（移動元が監視外）
FileSystemEventArgs {
    ChangeType = WatcherChangeTypes.Created,
    FullPath = "移動先パス",
    Name = "移動先名前"
}
```

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| wd | ウォッチ記述子 | inotify_add_watch() の戻り値 | Yes |
| mask | イベントマスク | IN_MOVED_TO (0x00000080) | Yes |
| cookie | イベント関連付け | カーネル生成の一意な値 | Yes |
| len | 名前長 | ファイル名のバイト長 + パディング | Yes |
| name | 移動先ファイル名 | 移動されたファイルの新しい名前 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| システムコール | rename() | ウォッチにIN_MOVED_TOが設定されている | ファイル/ディレクトリの移動時（移動先） |
| システムコール | renameat() | ウォッチにIN_MOVED_TOが設定されている | ディレクトリ相対でのリネーム時 |
| システムコール | renameat2() | ウォッチにIN_MOVED_TOが設定されている | 拡張リネーム時 |

### .NET での有効化条件

| 条件 | 説明 |
|-----|------|
| NotifyFilters.FileName | ファイルの移動検知に必要 |
| NotifyFilters.DirectoryName | ディレクトリの移動検知に必要 |
| IncludeSubdirectories | サブディレクトリ追跡のために内部的に追加される |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| NotifyFilters に FileName/DirectoryName なし | 移動イベントを監視しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[rename() システムコール] --> B[カーネル: IN_MOVED_TO 生成]
    B --> C[inotify キューに追加]
    C --> D[.NET: ProcessEvents スレッド]
    D --> E[TryReadEvent でイベント読み取り]
    E --> F{IN_MOVED_TO 検出}
    F --> G{保存済み IN_MOVED_FROM あり?}
    G -->|あり| H{cookie 一致?}
    G -->|なし| I[WatcherEvent.Created 生成]
    H -->|一致| J[WatcherEvent.Renamed 生成]
    H -->|不一致| I
    J --> K[EmitEvent → OnRenamed]
    I --> L[EmitEvent → OnCreated]
    K --> M[終了]
    L --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（OSカーネル通知のためデータベースを使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| IN_Q_OVERFLOW | inotify イベントキューが溢れた | Error イベント発生、監視再起動 |
| ペア不成立 | 対応する IN_MOVED_FROM がない | Created イベントとして処理 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | カーネル設定依存 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（24時間監視可能）

## セキュリティ考慮事項

- 移動元と移動先の両方のパス情報が取得可能
- 監視対象ディレクトリへの読み取り権限が必要
- 監視対象外からの移動は Created として処理される

## 備考

- IN_MOVED_FROM と IN_MOVED_TO は同じ cookie 値で関連付けられる
- IN_MOVED_FROM が先に到着し、IN_MOVED_TO を2ms待機する
- 監視対象外からの移動は Created イベントとして処理される
- ディレクトリの移動時、IncludeSubdirectories が true の場合は移動したサブディレクトリの監視も更新される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、IN_MOVED_TO の定義と関連する定数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Interop.INotify.cs | `src/libraries/Common/src/Interop/Linux/System.Native/Interop.INotify.cs` | IN_MOVED_TO 定数の定義（0x00000080） |

**読解のコツ**: NotifyEvents enum で IN_MOVED_TO = 0x00000080 として定義されている点、IN_MOVED_FROM = 0x00000040 との関係に注目。

#### Step 2: フィルタマッピングを理解する

NotifyFilters から inotify イベントへの変換ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | FileSystemWatcher.Linux.cs | `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` | TranslateFilters メソッドでの IN_MOVED_FROM/TO マッピング |

**主要処理フロー**:
- **行 1290-1298 (Linux.cs)**: filtersForMoved に FileName/DirectoryName が含まれる
- **行 1293-1298 (Linux.cs)**: IN_MOVED_FROM/TO をサブスクライブする条件判定

#### Step 3: ペアイベント処理を理解する

IN_MOVED_TO と IN_MOVED_FROM のペア処理ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | FileSystemWatcher.Linux.cs | `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` | ProcessEvent での IN_MOVED_TO 処理 |

**主要処理フロー**:
- **行 693-701 (Linux.cs)**: IN_MOVED_TO 検出時の処理
- **行 694-696 (Linux.cs)**: cookie マッチングで Renamed イベント生成
- **行 700 (Linux.cs)**: ペア不成立時に Created イベント生成

### プログラム呼び出し階層図

```
[Linux カーネル]
inotify イベント (IN_MOVED_TO)
    │
    ▼
[.NET FileSystemWatcher.Linux]
INotify.ProcessEvents()
    │
    ├─ TryReadEvent() → NotifyEvent 構造体
    │
    └─ ProcessEvent()
           │
           ├─ IN_MOVED_TO 検出
           │
           └─ [cookie マッチング]
                  │
                  ├─ [ペア成立] WatcherEvent.Renamed
                  │      └─ EmitEvent → OnRenamed
                  │
                  └─ [ペア不成立] WatcherEvent.Created
                         └─ EmitEvent → OnCreated
```

### データフロー図

```
[入力]                    [処理]                           [出力]

rename()                カーネル inotify
システムコール  ───▶    IN_MOVED_TO 生成  ───▶   inotify キュー
                              │
                              ▼
                        .NET ProcessEvent()
                              │
                        [cookie マッチング]
                              │
                 ┌────────────┴────────────┐
                 ▼                         ▼
          ペア成立                   ペア不成立
      (IN_MOVED_FROM あり)       (監視外からの移動)
                 │                         │
                 ▼                         ▼
          Renamed イベント          Created イベント
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Interop.INotify.cs | `src/libraries/Common/src/Interop/Linux/System.Native/Interop.INotify.cs` | ソース | IN_MOVED_TO 定数定義 |
| FileSystemWatcher.Linux.cs | `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` | ソース | IN_MOVED_TO イベント処理、ペアマッチング |
| FileSystemWatcher.cs | `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` | ソース | NotifyFilters、Renamed/Created イベント定義 |
| RenamedEventArgs.cs | `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/RenamedEventArgs.cs` | ソース | リネームイベント引数 |
| FileSystemEventArgs.cs | `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemEventArgs.cs` | ソース | 作成イベント引数 |
