---
generated_at: 2026-01-30 13:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-FileSystemWatcher.Changed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs`（全体）
- E-02: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemEventArgs.cs`（行9-77）
- E-03: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Win32.cs`
- E-04: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs`
- E-05: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.OSX.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FileSystemWatcherはComponentを継承しISupportInitializeを実装している | E-01（行20） | ○ |
| C-02 | Changedイベントが定義されている | E-01（行257-267） | ○ |
| C-03 | Created、Deleted、Renamedイベントも定義されている | E-01（行272-327） | ○ |
| C-04 | Errorイベントが定義されている | E-01（行302-312） | ○ |
| C-05 | System.IO名前空間に属する | E-01, E-02（namespace宣言） | ○ |
| C-06 | イベント引数はFileSystemEventArgs | E-01（行257）, E-02 | ○ |
| C-07 | ChangeTypeプロパティで変更種類を取得できる | E-02（行47-53） | ○ |
| C-08 | FullPathプロパティでフルパスを取得できる | E-02（行58-64） | ○ |
| C-09 | Nameプロパティでファイル名を取得できる | E-02（行70-76） | ○ |
| C-10 | デフォルトNotifyFilterはLastWrite、FileName、DirectoryName | E-01（行29） | ○ |
| C-11 | InternalBufferSizeのデフォルトは8192バイト | E-01（行42） | ○ |
| C-12 | InternalBufferSizeの最小は4096バイト | E-01（行212-214） | ○ |
| C-13 | OnChangedメソッドでイベントが発火される | E-01（行465-468） | ○ |
| C-14 | SynchronizingObjectでスレッドマーシャリングが可能 | E-01（行659） | ○ |
| C-15 | InvokeOnメソッドでSynchronizingObjectを考慮した呼び出し | E-01（行486-496） | ○ |
| C-16 | EnableRaisingEventsでイベント発火を制御 | E-01（行132-161） | ○ |
| C-17 | Filterプロパティでパターンフィルタリング | E-01（行166-177） | ○ |
| C-18 | IncludeSubdirectoriesでサブディレクトリ監視を制御 | E-01（行182-197） | ○ |
| C-19 | MatchPatternメソッドでフィルタマッチング | E-01（行374-391） | ○ |
| C-20 | NotifyFileSystemEventArgsでフィルタリングとイベント発火 | E-01（行439-460） | ○ |
| C-21 | Windows固有実装が存在する | E-03 | ○ |
| C-22 | Linux固有実装が存在する（inotify） | E-04 | ○ |
| C-23 | macOS固有実装が存在する | E-05 | ○ |
| C-24 | WaitForChangedメソッドで同期待機が可能 | E-01（行530-609） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に対してソースコードによる根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認済み
- 0: 低リスク - プラットフォーム固有実装も確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] FileSystemWatcher.cs の行257-267でChangedイベント定義を確認
- [ ] FileSystemEventArgs.cs のプロパティ（ChangeType, FullPath, Name）を確認
- [ ] OnChanged/InvokeOnメソッドの実装を確認
- [ ] NotifyFilter, Filter, EnableRaisingEventsプロパティの動作を確認
- [ ] プラットフォーム固有ファイル（Win32, Linux, OSX）の存在を確認
