---
generated_at: 2026-01-30 12:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：11-FileSystemWatcher.Created

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **ネットワークドライブでの信頼性**：実装コードからは直接確認できない動作特性
  2. **Windows実装の詳細**：ReadDirectoryChangesW の実装ファイルが未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 272-282（Created イベント定義）
- E-02: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 473-476（OnCreated メソッド）
- E-03: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 486-496（InvokeOn メソッド）
- E-04: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 439-447（NotifyFileSystemEventArgs）
- E-05: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemEventArgs.cs` 行 9-78（FileSystemEventArgs クラス全体）
- E-06: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemEventHandler.cs` 行 12（デリゲート定義）
- E-07: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 679-681（IN_CREATE 処理）
- E-08: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 700-701（IN_MOVED_TO のCreated変換）
- E-09: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 963（WatcherEvent.Created ファクトリ）
- E-10: `src/libraries/Common/src/Interop/Linux/System.Native/Interop.INotify.cs` 行 52（IN_CREATE 定義）
- E-11: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 132-161（EnableRaisingEvents プロパティ）
- E-12: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 374-391（MatchPattern メソッド）
- E-13: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 93-96（max_user_instances/max_user_watches パス定義）
- E-14: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 396-406（NotifyInternalBufferOverflowEvent）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Created イベントは新規ファイル/ディレクトリ作成時に発生 | E-01, E-07 | ○ |
| C-02 | FileSystemEventArgs で ChangeType、FullPath、Name が通知される | E-05 | ○ |
| C-03 | SynchronizingObject 設定時は BeginInvoke 経由で呼び出し | E-03 | ○ |
| C-04 | EnableRaisingEvents が false の場合は通知されない | E-11 | ○ |
| C-05 | Filter/Filters パターンマッチングでフィルタリング | E-12 | ○ |
| C-06 | Linux では inotify の IN_CREATE イベントを使用 | E-07, E-10 | ○ |
| C-07 | IN_MOVED_TO で移動元が監視外の場合は Created として扱う | E-08 | ○ |
| C-08 | InternalBufferOverflowException が Error イベントで通知される | E-14 | ○ |
| C-09 | Linux では max_user_instances/max_user_watches の制限がある | E-13 | ○ |
| C-10 | OnCreated メソッドでイベントが発火される | E-02 | ○ |
| C-11 | FileSystemEventHandler デリゲートが使用される | E-06 | ○ |
| C-12 | WatcherEvent.Created ファクトリメソッドでイベント生成 | E-09 | ○ |
| C-13 | NotifyFileSystemEventArgs でフィルタチェック後にイベント発火 | E-04 | ○ |
| C-14 | IncludeSubdirectories でサブディレクトリも監視可能 | E-11 | ○ |
| C-15 | ThreadPool 経由で非同期にイベント配信 | E-07 | ○ |
| C-16 | マルチキャストデリゲートで複数ハンドラ呼び出し | E-01 | ○ |
| C-17 | Windows では ReadDirectoryChangesW を使用 | **根拠なし** | △ |
| C-18 | ネットワークドライブでの監視は信頼性が低下する場合がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Windows 固有の実装ファイル（FileSystemWatcher.Windows.cs 等）が未確認のため、ReadDirectoryChangesW の使用については直接的な根拠を確認できていない
  - 候補：`src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Windows.cs`
- ネットワークドライブでの動作特性は実装コードからは直接確認できない（ドキュメントベースの情報）
  - 候補：公式ドキュメント / テストコード / Issue トラッカー

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Linux inotify 実装の記述は正確
- 1: 中リスク - Windows 実装の詳細が未確認（機能的には問題なし）
- 0: 低リスク - イベントデータ構造の記述は正確

## 6) レビュアーチェックリスト（最小）
- [ ] Windows 実装（ReadDirectoryChangesW）の記述が正確か確認
- [ ] ネットワークドライブでの動作に関する記述が適切か確認
- [ ] コードリーディングガイドの行番号が現在のソースコードと一致しているか確認
