---
generated_at: 2026-01-30 12:58:00
metrics:
  claims_total: 17
  claims_with_evidence: 15
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：12-FileSystemWatcher.Deleted

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：15 / 17、根拠なし：2
- 優先レビュー（高）
  1. **Windows実装の詳細**：ReadDirectoryChangesW の実装ファイルが未確認
  2. **削除されたファイル内容へのアクセス不可**：一般的な知識だが直接的な根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 287-297（Deleted イベント定義）
- E-02: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 481-484（OnDeleted メソッド）
- E-03: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 420-434（GetHandler メソッド）
- E-04: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemEventArgs.cs` 行 9-78（FileSystemEventArgs クラス）
- E-05: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 683-684（IN_DELETE 処理）
- E-06: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 585（IN_MOVED_FROM の Deleted 変換）
- E-07: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 691（IN_MOVED_FROM 単独処理）
- E-08: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 959-960（WatcherEvent.Deleted ファクトリ）
- E-09: `src/libraries/Common/src/Interop/Linux/System.Native/Interop.INotify.cs` 行 53（IN_DELETE 定義）
- E-10: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 617（2ms タイムアウト定数）
- E-11: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 660-664（IN_IGNORED 処理）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Deleted イベントは削除時に発生 | E-01, E-05 | ○ |
| C-02 | FileSystemEventArgs で通知データが渡される | E-04 | ○ |
| C-03 | SynchronizingObject 設定時は BeginInvoke 経由 | E-02 | ○ |
| C-04 | Linux では IN_DELETE イベントを使用 | E-05, E-09 | ○ |
| C-05 | IN_MOVED_FROM で移動先がない場合は Deleted | E-06, E-07 | ○ |
| C-06 | GetHandler で WatcherChangeTypes.Deleted に対応 | E-03 | ○ |
| C-07 | WatcherEvent.Deleted ファクトリメソッドでイベント生成 | E-08 | ○ |
| C-08 | 2ms タイムアウトで IN_MOVED_TO 待機 | E-10 | ○ |
| C-09 | IN_IGNORED でサブディレクトリの監視が解除される | E-11 | ○ |
| C-10 | OnDeleted メソッドでイベント発火 | E-02 | ○ |
| C-11 | EnableRaisingEvents false で通知抑止 | E-01 | ○ |
| C-12 | Filter/Filters でフィルタリング | E-03 | ○ |
| C-13 | ThreadPool 経由で非同期配信 | E-05 | ○ |
| C-14 | 削除されたファイルの内容にアクセス不可 | **根拠なし** | △ |
| C-15 | マルチキャストデリゲートで複数ハンドラ呼び出し | E-01 | ○ |
| C-16 | Windows では ReadDirectoryChangesW を使用 | **根拠なし** | △ |
| C-17 | IncludeSubdirectories でサブディレクトリも監視 | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- Windows 固有の実装ファイルが未確認のため、ReadDirectoryChangesW の使用については直接的な根拠を確認できていない
  - 候補：`src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Windows.cs`
- 削除されたファイルの内容にアクセスできないことは一般的なファイルシステムの知識だが、コードからの直接的な根拠はない
  - 候補：公式ドキュメント / ファイルシステム仕様書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Linux inotify 実装の記述は正確
- 1: 中リスク - Windows 実装の詳細が未確認
- 0: 低リスク - イベントデータ構造の記述は正確

## 6) レビュアーチェックリスト（最小）
- [ ] Windows 実装（ReadDirectoryChangesW）の記述が正確か確認
- [ ] IN_MOVED_FROM のタイムアウト処理の記述が正確か確認
- [ ] コードリーディングガイドの行番号が現在のソースコードと一致しているか確認
