---
generated_at: 2026-01-30 13:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：13-FileSystemWatcher.Renamed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Windows実装の詳細**：ReadDirectoryChangesW の実装ファイルが未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 318-328（Renamed イベント定義）
- E-02: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 517-528（OnRenamed メソッド）
- E-03: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 410-418（NotifyRenameEventArgs メソッド）
- E-04: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/RenamedEventArgs.cs` 行 9-46（RenamedEventArgs クラス）
- E-05: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 549-593（IN_MOVED_FROM 処理）
- E-06: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 567（cookie マッチング）
- E-07: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 604-631（タイムアウト待機）
- E-08: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 617（2ms タイムアウト定数）
- E-09: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 693-701（IN_MOVED_TO の処理）
- E-10: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 968-969（WatcherEvent.Renamed ファクトリ）
- E-11: `src/libraries/Common/src/Interop/Linux/System.Native/Interop.INotify.cs` 行 50-51（IN_MOVED_FROM/TO 定義）
- E-12: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 374-391（MatchPattern メソッド）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Renamed イベントは名前変更時に発生 | E-01 | ○ |
| C-02 | RenamedEventArgs で新旧名前が渡される | E-04 | ○ |
| C-03 | OldFullPath、OldName プロパティが追加されている | E-04 | ○ |
| C-04 | SynchronizingObject 設定時は BeginInvoke 経由 | E-02 | ○ |
| C-05 | Linux では IN_MOVED_FROM + IN_MOVED_TO ペアで検知 | E-05, E-09, E-11 | ○ |
| C-06 | cookie 値でペアを関連付け | E-06 | ○ |
| C-07 | 2ms タイムアウトで IN_MOVED_TO を待機 | E-07, E-08 | ○ |
| C-08 | タイムアウト時は Deleted として処理 | E-05 | ○ |
| C-09 | IN_MOVED_TO のみの場合は Created として処理 | E-09 | ○ |
| C-10 | WatcherEvent.Renamed ファクトリメソッドでイベント生成 | E-10 | ○ |
| C-11 | OnRenamed メソッドでイベント発火 | E-02 | ○ |
| C-12 | 新旧どちらかの名前がフィルタにマッチすれば通知 | E-03, E-12 | ○ |
| C-13 | NotifyRenameEventArgs でフィルタチェック | E-03 | ○ |
| C-14 | RenamedEventArgs は FileSystemEventArgs を継承 | E-04 | ○ |
| C-15 | RenamedEventHandler デリゲートが使用される | E-01, E-02 | ○ |
| C-16 | ThreadPool 経由で非同期配信 | E-05 | ○ |
| C-17 | IncludeSubdirectories でサブディレクトリも監視 | E-05 | ○ |
| C-18 | Windows では ReadDirectoryChangesW を使用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Windows 固有の実装ファイルが未確認のため、ReadDirectoryChangesW の使用については直接的な根拠を確認できていない
  - 候補：`src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Windows.cs`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Linux inotify のペア処理ロジックは詳細に確認済み
- 0: 低リスク - RenamedEventArgs のデータ構造は正確
- 1: 中リスク - Windows 実装の詳細が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] Windows 実装（ReadDirectoryChangesW）の記述が正確か確認
- [ ] cookie によるペアマッチングのロジックが正確か確認
- [ ] タイムアウト値（2ms）が現在のソースコードと一致しているか確認
- [ ] コードリーディングガイドの行番号が現在のソースコードと一致しているか確認
