---
generated_at: 2026-01-30 13:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：14-FileSystemWatcher.Error

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Windows実装のエラー処理**：Windows 固有のエラー処理が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 302-312（Error イベント定義）
- E-02: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 501-512（OnError メソッド）
- E-03: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 396-406（NotifyInternalBufferOverflowEvent）
- E-04: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 404-405（CreateBufferOverflowException）
- E-05: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/ErrorEventArgs.cs` 行 9-29（ErrorEventArgs クラス）
- E-06: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/ErrorEventHandler.cs` 行 11（デリゲート定義）
- E-07: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 535-546（IN_Q_OVERFLOW 処理）
- E-08: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 156-166（EMFILE/ENFILE エラー処理）
- E-09: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 272-287（ENOSPC エラー処理）
- E-10: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 1221-1227（QueueError メソッド）
- E-11: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 1136（EmitEvent での ErrorType 処理）
- E-12: `src/libraries/Common/src/Interop/Linux/System.Native/Interop.INotify.cs` 行 54（IN_Q_OVERFLOW 定義）
- E-13: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 93-96（max_user パス定義）
- E-14: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 1140-1146（InternalBufferOverflowException 後の再起動）
- E-15: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 202-224（InternalBufferSize プロパティ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Error イベントはエラー発生時に発生 | E-01, E-02 | ○ |
| C-02 | ErrorEventArgs で例外が渡される | E-05 | ○ |
| C-03 | GetException() で例外を取得 | E-05 | ○ |
| C-04 | SynchronizingObject 設定時は BeginInvoke 経由 | E-02 | ○ |
| C-05 | InternalBufferOverflowException はバッファ溢れで発生 | E-03, E-04 | ○ |
| C-06 | IN_Q_OVERFLOW で inotify キューオーバーフロー検知 | E-07, E-12 | ○ |
| C-07 | EMFILE で inotify インスタンス数超過 | E-08 | ○ |
| C-08 | ENOSPC でウォッチ数超過 | E-09 | ○ |
| C-09 | ENFILE でシステム全体の上限超過 | E-08 | ○ |
| C-10 | QueueError でエラーをキューに追加 | E-10 | ○ |
| C-11 | EmitEvent で ErrorType を処理 | E-11 | ○ |
| C-12 | InternalBufferOverflowException 後に自動再起動 | E-14 | ○ |
| C-13 | InternalBufferSize で最小4096バイト | E-15 | ○ |
| C-14 | max_user_instances/max_user_watches で上限確認可能 | E-13 | ○ |
| C-15 | OnError メソッドでイベント発火 | E-02 | ○ |
| C-16 | ErrorEventHandler デリゲートが使用される | E-06 | ○ |
| C-17 | _onErrorHandler が null で早期リターン | E-03 | ○ |
| C-18 | Windows でのエラー処理の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Windows 固有の実装ファイルが未確認のため、Windows でのエラー処理については直接的な根拠を確認できていない
  - 候補：`src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Windows.cs`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Linux inotify のエラー処理は詳細に確認済み
- 0: 低リスク - ErrorEventArgs のデータ構造は正確
- 1: 中リスク - Windows 実装のエラー処理が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] Windows 実装のエラー処理が正確に記述されているか確認
- [ ] InternalBufferOverflowException 後の自動再起動の動作が正確か確認
- [ ] コードリーディングガイドの行番号が現在のソースコードと一致しているか確認
