---
generated_at: 2026-01-30 13:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：15-Interop.Sys.INotify (IN_ACCESS)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **noatime/relatime マウントオプションの動作**：Linux カーネルの動作であり、.NET コードからは直接確認できない

## 2) 参照した情報（Evidence一覧）

- E-01: `src/libraries/Common/src/Interop/Linux/System.Native/Interop.INotify.cs` 行 47（IN_ACCESS = 0x00000001）
- E-02: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 1261-1262（filtersForAccess 定義）
- E-03: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 1275-1278（IN_ACCESS サブスクライブ条件）
- E-04: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 527-529（EventMask に IN_ACCESS 含む）
- E-05: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 685-688（IN_ACCESS での Changed 生成）
- E-06: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 965-966（WatcherEvent.Changed ファクトリ）
- E-07: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 257-267（Changed イベント定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IN_ACCESS は 0x00000001 として定義 | E-01 | ○ |
| C-02 | NotifyFilters.LastAccess で IN_ACCESS が有効化 | E-02, E-03 | ○ |
| C-03 | IN_ACCESS は Changed イベントに変換される | E-05, E-06 | ○ |
| C-04 | EventMask に IN_ACCESS が含まれる | E-04 | ○ |
| C-05 | WatcherEvent.Changed で Changed イベント生成 | E-05, E-06 | ○ |
| C-06 | Changed イベントで通知される | E-07 | ○ |
| C-07 | filtersForAccess に LastAccess が含まれる | E-02 | ○ |
| C-08 | 単一の inotify インスタンスを共有 | E-03 | ○ |
| C-09 | ProcessEvent で mask 判定 | E-04, E-05 | ○ |
| C-10 | cookie は 0（ペアイベントではない） | E-01 | ○ |
| C-11 | wd でウォッチを識別 | E-01 | ○ |
| C-12 | name でファイル名を取得 | E-05 | ○ |
| C-13 | IN_Q_OVERFLOW でキューオーバーフロー検知 | E-04 | ○ |
| C-14 | TranslateFilters でマッピング | E-02, E-03 | ○ |
| C-15 | noatime/relatime でIN_ACCESS が発生しない場合がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- noatime/relatime マウントオプションの動作は Linux カーネルの仕様であり、.NET コードからは直接確認できない
  - 候補：Linux カーネルドキュメント / man inotify(7)

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - IN_ACCESS の定義と処理フローは正確
- 0: 低リスク - NotifyFilters とのマッピングは正確
- 1: 中リスク - マウントオプションに関する記述は Linux カーネル依存

## 6) レビュアーチェックリスト（最小）
- [ ] IN_ACCESS の値（0x00000001）が現在のソースコードと一致しているか確認
- [ ] TranslateFilters での LastAccess → IN_ACCESS マッピングが正確か確認
- [ ] コードリーディングガイドの行番号が現在のソースコードと一致しているか確認
