---
generated_at: 2026-01-30 13:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-Interop.Sys.INotify (IN_ATTRIB)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/libraries/Common/src/Interop/Linux/System.Native/Interop.INotify.cs` 行 49（IN_ATTRIB = 0x00000004）
- E-02: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 1268-1274（filtersForAttrib 定義）
- E-03: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 1283-1286（IN_ATTRIB サブスクライブ条件）
- E-04: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 527-529（EventMask に IN_ATTRIB 含む）
- E-05: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 685-688（IN_ATTRIB での Changed 生成）
- E-06: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 965-966（WatcherEvent.Changed ファクトリ）
- E-07: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 257-267（Changed イベント定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IN_ATTRIB は 0x00000004 として定義 | E-01 | ○ |
| C-02 | 6つのフィルタで IN_ATTRIB が有効化 | E-02, E-03 | ○ |
| C-03 | IN_ATTRIB は Changed イベントに変換される | E-05, E-06 | ○ |
| C-04 | EventMask に IN_ATTRIB が含まれる | E-04 | ○ |
| C-05 | WatcherEvent.Changed で Changed イベント生成 | E-05, E-06 | ○ |
| C-06 | Changed イベントで通知される | E-07 | ○ |
| C-07 | filtersForAttrib に Attributes 等が含まれる | E-02 | ○ |
| C-08 | 単一の inotify インスタンスを共有 | E-03 | ○ |
| C-09 | ProcessEvent で mask 判定 | E-04, E-05 | ○ |
| C-10 | cookie は 0（ペアイベントではない） | E-01 | ○ |
| C-11 | wd でウォッチを識別 | E-01 | ○ |
| C-12 | name でファイル名を取得 | E-05 | ○ |
| C-13 | TranslateFilters でマッピング | E-02, E-03 | ○ |
| C-14 | chmod/chown 等でトリガー | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - IN_ATTRIB の定義と処理フローは正確
- 0: 低リスク - NotifyFilters とのマッピングは正確
- 0: 低リスク - Changed イベントへの変換は正確

## 6) レビュアーチェックリスト（最小）
- [ ] IN_ATTRIB の値（0x00000004）が現在のソースコードと一致しているか確認
- [ ] TranslateFilters での filtersForAttrib マッピングが正確か確認
- [ ] コードリーディングガイドの行番号が現在のソースコードと一致しているか確認
