---
generated_at: 2026-01-30 13:18:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-Interop.Sys.INotify (IN_MOVED_FROM)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/libraries/Common/src/Interop/Linux/System.Native/Interop.INotify.cs` 行 50（IN_MOVED_FROM = 0x00000040）
- E-02: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 1290-1298（filtersForMoved 定義）
- E-03: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 253-256（IncludeSubdirectories での追加）
- E-04: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 604-631（IN_MOVED_FROM 処理）
- E-05: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 617（2ms タイムアウト）
- E-06: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 567-593（cookie マッチング）
- E-07: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 585（タイムアウト時の Deleted 処理）
- E-08: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 968-969（WatcherEvent.Renamed ファクトリ）
- E-09: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/RenamedEventArgs.cs` 行 9-46（RenamedEventArgs クラス）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IN_MOVED_FROM は 0x00000040 として定義 | E-01 | ○ |
| C-02 | FileName/DirectoryName で有効化 | E-02 | ○ |
| C-03 | IncludeSubdirectories で内部的に追加 | E-03 | ○ |
| C-04 | cookie で IN_MOVED_TO と関連付け | E-06 | ○ |
| C-05 | 2ms タイムアウトで IN_MOVED_TO 待機 | E-04, E-05 | ○ |
| C-06 | タイムアウト時は Deleted として処理 | E-07 | ○ |
| C-07 | ペア成立時は Renamed イベント | E-08 | ○ |
| C-08 | RenamedEventArgs に OldName/OldFullPath | E-09 | ○ |
| C-09 | Poll で待機 | E-04 | ○ |
| C-10 | cookie/name を保存 | E-04 | ○ |
| C-11 | rename() システムコールでトリガー | E-01 | ○ |
| C-12 | 監視対象外への移動は Deleted | E-07 | ○ |
| C-13 | ProcessEvent で処理 | E-04 | ○ |
| C-14 | IN_MOVED_TO = 0x00000080 | E-01 | ○ |
| C-15 | filtersForMoved に FileName/DirectoryName | E-02 | ○ |
| C-16 | WatcherEvent.Renamed ファクトリメソッド | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - IN_MOVED_FROM の定義と処理フローは正確
- 0: 低リスク - ペアマッチングロジックは詳細に確認済み
- 0: 低リスク - タイムアウト処理は正確

## 6) レビュアーチェックリスト（最小）
- [ ] IN_MOVED_FROM の値（0x00000040）が現在のソースコードと一致しているか確認
- [ ] 2ms タイムアウト値が現在のソースコードと一致しているか確認
- [ ] コードリーディングガイドの行番号が現在のソースコードと一致しているか確認
