---
generated_at: 2026-01-30 13:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 11
  claims_without_evidence: 3
confidence_derived: 0.79
---

# 根拠レポート：2-INotifyPropertyChanging.PropertyChanging

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.79**
  - 根拠あり：11 / 14、根拠なし：3
- 優先レビュー（高）
  1. **Entity Frameworkでの使用**: 外部ドキュメントの確認が必要
  2. **Undo/Redo機能での使用**: 具体的な実装例がリポジトリ内に存在しない
  3. **PropertyChangingEventArgs定義**: 直接のソースファイルが見つからず

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.ObjectModel/src/System/ComponentModel/INotifyPropertyChanging.cs`（行6-9）
- E-02: `src/libraries/System.ObjectModel/src/System/ComponentModel/INotifyPropertyChanged.cs`（参考：対になるインターフェース）
- E-03: `src/libraries/System.ObjectModel/ref/System.ObjectModel.cs`（リファレンスアセンブリ定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | INotifyPropertyChangingインターフェースはPropertyChangingイベントを定義している | E-01（行8） | ○ |
| C-02 | PropertyChangingEventArgsはPropertyNameプロパティを持つ | E-03（リファレンス定義） | ○ |
| C-03 | INotifyPropertyChangedと対になるインターフェースである | E-01, E-02（名前とシグネチャの類似性） | ○ |
| C-04 | System.ComponentModel名前空間に属する | E-01（namespace宣言） | ○ |
| C-05 | 変更前に発火される（セマンティクス） | E-01（インターフェース名のing接尾辞）、.NET仕様 | ○ |
| C-06 | Entity Frameworkで変更追跡に使用される | **根拠なし**（EFは別リポジトリ） | △ |
| C-07 | Undo/Redo機能の実装に使用される | **根拠なし**（設計パターンとして一般的だが具体例なし） | △ |
| C-08 | イベントはマルチキャストデリゲートとして通知される | E-01（eventキーワードの使用） | ○ |
| C-09 | PropertyChangingEventArgsはEventArgsを継承 | E-03 | ○ |
| C-10 | イベントハンドラの型はPropertyChangingEventHandler | E-01（行8） | ○ |
| C-11 | 変更をキャンセルする機能を持たない | E-01（イベント引数にキャンセル機能なし） | ○ |
| C-12 | .NET Standard 2.0以降でサポート | **根拠なし**（TFM確認が必要） | △ |
| C-13 | 同期的にイベントが発火される | E-01（標準的なeventパターン） | ○ |
| C-14 | null条件演算子で安全に発火すべき | 一般的なC#ベストプラクティス | ○ |

## 4) 不足情報（Unknown / Missing）
- **Entity Frameworkでの使用（C-06）**：Entity Frameworkは別リポジトリ（dotnet/efcore）で管理されている。変更追跡での使用はEFドキュメントを参照する必要がある。
  - 候補：dotnet/efcore リポジトリ / Microsoft Docs EF Core
- **Undo/Redo機能での使用（C-07）**：設計パターンとしては一般的だが、.NET Runtimeリポジトリ内には具体的な実装例が存在しない。
  - 候補：Windows Community Toolkit / Prism Library
- **PropertyChangingEventArgs定義（C-02）**：インターフェースファイルには含まれておらず、別ファイルまたはリファレンスアセンブリで定義されている。
  - 候補：System.ObjectModel の別ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェース定義はソースコードで確認済み
- 1: 中リスク - 具体的な実装例がリポジトリ内に少ない
- 1: 中リスク - Entity FrameworkやUndo/Redoでの使用は外部ドキュメント依存

## 6) レビュアーチェックリスト（最小）
- [ ] INotifyPropertyChanging.cs の行8でイベント定義を確認
- [ ] PropertyChangingEventArgs の定義場所を確認
- [ ] INotifyPropertyChangedとの構造的類似性を確認
- [ ] Entity Framework等での実際の使用例を外部ドキュメントで確認
