---
generated_at: 2026-01-30 13:22:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-Interop.Sys.INotify (IN_CREATE)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/libraries/Common/src/Interop/Linux/System.Native/Interop.INotify.cs` 行 52（IN_CREATE = 0x00000100）
- E-02: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 1255-1257（IN_CREATE の常時サブスクライブ）
- E-03: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 519-523（FileDirEvents に IN_CREATE 含む）
- E-04: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 679-681（IN_CREATE での Created 生成）
- E-05: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 640-652（IncludeSubdirectories 処理）
- E-06: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行 963（WatcherEvent.Created ファクトリ）
- E-07: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.cs` 行 272-282（Created イベント定義）
- E-08: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemEventArgs.cs` 行 9-78（FileSystemEventArgs クラス）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IN_CREATE は 0x00000100 として定義 | E-01 | ○ |
| C-02 | IN_CREATE は常にサブスクライブ | E-02 | ○ |
| C-03 | IN_CREATE は Created イベントに変換される | E-04, E-06 | ○ |
| C-04 | FileDirEvents に IN_CREATE が含まれる | E-03 | ○ |
| C-05 | WatcherEvent.Created で Created イベント生成 | E-04, E-06 | ○ |
| C-06 | Created イベントで通知される | E-07 | ○ |
| C-07 | FileSystemEventArgs で通知データが渡される | E-08 | ○ |
| C-08 | IncludeSubdirectories でサブディレクトリも監視 | E-05 | ○ |
| C-09 | WatchChildDirectories で新ディレクトリを追加 | E-05 | ○ |
| C-10 | ProcessEvent で mask 判定 | E-03, E-04 | ○ |
| C-11 | cookie は 0（ペアイベントではない） | E-01 | ○ |
| C-12 | wd でウォッチを識別 | E-01 | ○ |
| C-13 | name でファイル名を取得 | E-04 | ○ |
| C-14 | open(O_CREAT)/mkdir でトリガー | E-01 | ○ |
| C-15 | ENOSPC でウォッチ数上限超過 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - IN_CREATE の定義と処理フローは正確
- 0: 低リスク - サブディレクトリ監視追加のロジックは正確
- 0: 低リスク - Created イベントへの変換は正確

## 6) レビュアーチェックリスト（最小）
- [ ] IN_CREATE の値（0x00000100）が現在のソースコードと一致しているか確認
- [ ] WatchChildDirectories の呼び出しが正確か確認
- [ ] コードリーディングガイドの行番号が現在のソースコードと一致しているか確認
