---
generated_at: 2026-01-30 12:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：21-Interop.Sys.INotify_IN_DELETE.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **カーネルキュー設定のデフォルト値**：システム依存のため要確認
  2. **セキュリティ考慮事項の詳細**：カーネルドキュメント参照推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/native/libs/System.Native/pal_io.h` 行328-344 NotifyEvents列挙型
- E-02: `src/native/libs/System.Native/pal_io.c` 行1476-1521 INotify関数実装
- E-03: `src/native/libs/System.Native/pal_io.c` 行184-200 静的アサート
- E-04: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行516-773 ProcessEvent
- E-05: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行682-683 IN_DELETEケース
- E-06: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行1245-1258 TranslateFilters
- E-07: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行519-523 FileDirEventsマスク
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 行22 IN_DELETE定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IN_DELETEの値は0x00000200である | E-01 (行337: PAL_IN_DELETE = 0x00000200) | ○ |
| C-02 | inotify_init1でIN_CLOEXECフラグを使用する | E-02 (行1479: inotify_init1(IN_CLOEXEC)) | ○ |
| C-03 | inotify_add_watchでマスクを設定する | E-02 (行1495: inotify_add_watch呼び出し) | ○ |
| C-04 | PAL定数とカーネル定数の一致を静的アサートで検証 | E-03 (行191: c_static_assert(PAL_IN_DELETE == IN_DELETE)) | ○ |
| C-05 | ProcessEvent関数でIN_DELETEを処理する | E-04 (行516-773: ProcessEvent関数全体) | ○ |
| C-06 | IN_DELETEケースでWatcherEvent.Deletedを生成 | E-05 (行683: watcher.QueueEvent(WatcherEvent.Deleted)) | ○ |
| C-07 | FileDirEventsにIN_DELETEが含まれる | E-07 (行521: IN_DELETE含む) | ○ |
| C-08 | TranslateFiltersでIN_DELETEフィルタを設定 | E-06 (行1256-1257: IN_CREATE, IN_DELETE設定) | ○ |
| C-09 | 通知一覧CSVでIN_DELETEが定義されている | E-08 | ○ |
| C-10 | inotify_event構造体の構成 | Linux manpage (外部ドキュメント) | ○ |
| C-11 | IN_EXCLUNLINKフラグのサポート | E-02 (行1492-1494: IN_EXCL_UNLINK条件分岐) | ○ |
| C-12 | cookieフィールドは削除イベントで未使用 | E-04 (行549-551: movedFromCookieの説明) | ○ |
| C-13 | EmitEvent関数でDeletedイベントを発火 | E-04 (行1149-1165: EmitEvent実装) | ○ |
| C-14 | WeakReferenceでFileSystemWatcherを参照 | E-04 (行992-993: WeakReference使用) | ○ |
| C-15 | Channelを使用したイベントキュー | E-04 (行1029: Channel.CreateUnbounded) | ○ |
| C-16 | TryReadEventでバッファからイベント解析 | E-04 (行837-894: TryReadEvent実装) | ○ |
| C-17 | max_queued_eventsのデフォルト値16384 | **根拠なし** - カーネルドキュメント参照必要 | △ |
| C-18 | 読み取り権限が必要 | **根拠なし** - カーネルセキュリティモデル参照必要 | △ |

## 4) 不足情報（Unknown / Missing）
- カーネルのmax_queued_eventsデフォルト値（C-17）
  - 候補：Linux kernel documentation / /proc/sys/fs/inotify/max_queued_events のデフォルト値確認
- inotifyのセキュリティモデル詳細（C-18）
  - 候補：man 7 inotify / Linux kernel source / security documentation

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認できる技術的詳細
- 1: 中リスク - カーネル設定値は環境依存の可能性あり
- 0: 低リスク - 処理フロー図はコード解析に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] PAL_IN_DELETE定数値（0x00000200）がpal_io.hで正しく定義されているか確認
- [ ] ProcessEvent関数のIN_DELETEケース処理が設計書と一致するか確認
- [ ] max_queued_eventsのデフォルト値を実環境で確認
- [ ] セキュリティ考慮事項がLinux inotify manpageと整合するか確認
