---
generated_at: 2026-01-30 13:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：22-Interop.Sys.INotify_IN_Q_OVERFLOW.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **max_queued_eventsのデフォルト値**：カーネルドキュメント参照推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/native/libs/System.Native/pal_io.h` 行338 PAL_IN_Q_OVERFLOW定義
- E-02: `src/native/libs/System.Native/pal_io.c` 行192 静的アサート
- E-03: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行535-547 IN_Q_OVERFLOW検出・処理
- E-04: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行1136-1146 EmitEventでのエラー処理
- E-05: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行537-545 StopINotifyとQueueError呼び出し
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行23 IN_Q_OVERFLOW定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IN_Q_OVERFLOWの値は0x00004000である | E-01 (行338: PAL_IN_Q_OVERFLOW = 0x00004000) | ○ |
| C-02 | PAL定数とカーネル定数の一致を静的アサートで検証 | E-02 (行192: c_static_assert) | ○ |
| C-03 | ProcessEventでIN_Q_OVERFLOW検出 | E-03 (行535: mask & IN_Q_OVERFLOW判定) | ○ |
| C-04 | オーバーフロー時にStopINotify()を呼び出す | E-05 (行539: StopINotify()呼び出し) | ○ |
| C-05 | 全watcherにQueueError()でエラーを通知 | E-05 (行541-544: foreach watcher, QueueError) | ○ |
| C-06 | CreateBufferOverflowException()でエラー生成 | E-03 (行543: CreateBufferOverflowException) | ○ |
| C-07 | EmitEventでInternalBufferOverflowExceptionを処理 | E-04 (行1140: instanceof判定) | ○ |
| C-08 | オーバーフロー後にFileSystemWatcher.Restart()を呼び出す | E-04 (行1144: fsw.Restart()) | ○ |
| C-09 | オーバーフローイベントのwdは-1 | E-03 (コメント説明), Linux manpage | ○ |
| C-10 | オーバーフロー時はfalseを返して処理終了 | E-03 (行546: return false) | ○ |
| C-11 | s_watchersLockでロックを取得 | E-03 (行537: lock(s_watchersLock)) | ○ |
| C-12 | 通知一覧CSVでIN_Q_OVERFLOWが定義されている | E-06 | ○ |
| C-13 | ErrorイベントがFileSystemWatcherから発火 | E-04 (行1136: fsw.OnError) | ○ |
| C-14 | IsWatcherStopped判定後にRestart | E-04 (行1142-1144: if(!IsWatcherStopped) Restart) | ○ |
| C-15 | max_queued_eventsのデフォルト値16384 | **根拠なし** - カーネルドキュメント参照必要 | △ |

## 4) 不足情報（Unknown / Missing）
- カーネルのmax_queued_eventsデフォルト値（C-15）
  - 候補：Linux kernel documentation / /proc/sys/fs/inotify/max_queued_events のデフォルト値確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認できる技術的詳細
- 1: 中リスク - カーネル設定値は環境依存の可能性あり
- 0: 低リスク - 処理フロー図はコード解析に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] PAL_IN_Q_OVERFLOW定数値（0x00004000）がpal_io.hで正しく定義されているか確認
- [ ] ProcessEvent関数のIN_Q_OVERFLOW検出処理が設計書と一致するか確認
- [ ] StopINotify、QueueError、Restartの呼び出しシーケンスが正しいか確認
- [ ] max_queued_eventsのデフォルト値を実環境で確認
