---
generated_at: 2026-01-30 13:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-Interop.Sys.INotify_IN_IGNORED.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/native/libs/System.Native/pal_io.h` 行339 PAL_IN_IGNORED定義
- E-02: `src/native/libs/System.Native/pal_io.c` 行193 静的アサート
- E-03: `src/native/libs/System.Native/pal_io.c` 行1503-1521 INotifyRemoveWatch実装
- E-04: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行599 isDir判定
- E-05: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行660-664 IN_IGNORED処理
- E-06: `src/libraries/System.IO.FileSystem.Watcher/src/System/IO/FileSystemWatcher.Linux.cs` 行345-355 RemoveWatchedDirectory
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 行24 IN_IGNORED定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IN_IGNOREDの値は0x00008000である | E-01 (行339: PAL_IN_IGNORED = 0x00008000) | ○ |
| C-02 | PAL定数とカーネル定数の一致を静的アサートで検証 | E-02 (行193: c_static_assert(PAL_IN_IGNORED == IN_IGNORED)) | ○ |
| C-03 | SystemNative_INotifyRemoveWatchでinotify_rm_watchを呼び出す | E-03 (行1509-1515: inotify_rm_watch呼び出し) | ○ |
| C-04 | IN_IGNOREDはisDir判定に影響する | E-04 (行599: mask & (IN_ISDIR \| IN_IGNORED)) | ○ |
| C-05 | ProcessEventでIN_IGNORED検出 | E-05 (行660: mask & IN_IGNORED判定) | ○ |
| C-06 | IN_IGNORED時にRemoveWatchedDirectoryを呼び出す | E-05 (行662: RemoveWatchedDirectory呼び出し) | ○ |
| C-07 | ignoredFdパラメータでwdを渡す | E-05 (行662: ignoredFd: nextEvent.wd) | ○ |
| C-08 | IN_IGNORED処理後にcontinueで他処理をスキップ | E-05 (行663: continue) | ○ |
| C-09 | RemoveWatchedDirectoryが内部データ構造をクリーンアップ | E-06 (行345-355: 実装詳細) | ○ |
| C-10 | 通知一覧CSVでIN_IGNOREDが定義されている | E-07 | ○ |
| C-11 | IN_IGNOREDはディレクトリイベントとして扱われる | E-04 (行599のコメント参照) | ○ |
| C-12 | RemoveWatchedDirectoryFromParentAndWatchesで親と監視を更新 | E-06, FileSystemWatcher.Linux.cs 行414参照 | ○ |
| C-13 | _wdToWatch辞書からwdを削除 | FileSystemWatcher.Linux.cs 行402 TryRemove | ○ |
| C-14 | Watch.Watchersリストを更新 | FileSystemWatcher.Linux.cs 行466 Watchers.Remove | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠があります）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] PAL_IN_IGNORED定数値（0x00008000）がpal_io.hで正しく定義されているか確認
- [ ] ProcessEvent関数のIN_IGNORED検出・処理が設計書と一致するか確認
- [ ] RemoveWatchedDirectoryのリソースクリーンアップ処理が適切か確認
