---
generated_at: 2026-01-30 13:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-SmtpClient.SendCompleted.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Net.Mail/src/System/Net/Mail/SmtpClient.cs` 行21 SendCompletedEventHandlerデリゲート
- E-02: `src/libraries/System.Net.Mail/src/System/Net/Mail/SmtpClient.cs` 行57 SendCompletedイベント宣言
- E-03: `src/libraries/System.Net.Mail/src/System/Net/Mail/SmtpClient.cs` 行380-383 OnSendCompleted実装
- E-04: `src/libraries/System.Net.Mail/src/System/Net/Mail/SmtpClient.cs` 行574-579 finally句でのイベント発火
- E-05: `src/libraries/System.Net.Mail/src/System/Net/Mail/SmtpClient.cs` 行591-605 SendAsyncメソッド
- E-06: `src/libraries/System.Net.Mail/src/System/Net/Mail/SmtpClient.cs` 行410-583 SendAsyncInternal実装
- E-07: `src/libraries/System.Net.Mail/src/System/Net/Mail/SmtpClient.cs` 行621-635 SendAsyncCancel実装
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 行25 SendCompleted定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SendCompletedEventHandlerデリゲートが行21で定義 | E-01 (行21: public delegate void SendCompletedEventHandler) | ○ |
| C-02 | SendCompletedイベントが行57で宣言 | E-02 (行57: public event SendCompletedEventHandler? SendCompleted) | ○ |
| C-03 | OnSendCompletedでSendCompleted?.Invokeを呼び出す | E-03 (行382: SendCompleted?.Invoke(this, e)) | ○ |
| C-04 | finally句でinvokeSendCompleted && !synchronous判定 | E-04 (行575: if (invokeSendCompleted && !synchronous)) | ○ |
| C-05 | AsyncCompletedEventArgsを生成してOnSendCompletedに渡す | E-04 (行577: AsyncCompletedEventArgs eventArgs = new(...)) | ○ |
| C-06 | SendAsyncがSendAsyncInternalをinvokeSendCompleted=trueで呼び出す | E-05 (行593: SendAsyncInternal...true) | ○ |
| C-07 | Interlocked.Exchangeで同時実行を防止 | E-06 (行436: Interlocked.Exchange(ref _inCall, true)) | ○ |
| C-08 | キャンセル時にcanceled=trueが設定される | E-06 (行549: canceled = e is OperationCanceledException) | ○ |
| C-09 | finally句で_inCall = false | E-04 (行571: _inCall = false) | ○ |
| C-10 | ProcessExceptionで例外を処理 | E-06 (行541: exception = ProcessException(e, ...)) | ○ |
| C-11 | SendAsyncCancelで_pendingSendCts.Cancel()を呼び出す | E-07 (行633: currentCts.Cancel()) | ○ |
| C-12 | SmtpFailedRecipientExceptionは特別処理される | E-06 (行544-547: instanceof判定) | ○ |
| C-13 | 通知一覧CSVでSendCompletedが定義されている | E-08 | ○ |
| C-14 | タイムアウト時はSmtpExceptionがスローされる | E-06 (行552-555: if (timedOut) new SmtpException(SR.net_timeout)) | ○ |
| C-15 | SendMailAsyncはSendCompletedイベントを発火しない | E-06 (行663: SendAsyncInternal...false, null, true, cancellationToken) | ○ |
| C-16 | userTokenはAsyncCompletedEventArgs.UserStateとして渡される | E-04 (行577: eventArgs生成時にuserToken使用) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠があります）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] SendCompletedEventHandlerデリゲートとSendCompletedイベントの宣言を確認
- [ ] OnSendCompletedメソッドの実装を確認
- [ ] finally句でのイベント発火条件（invokeSendCompleted && !synchronous）を確認
- [ ] SendAsyncとSendMailAsyncでのinvokeSendCompletedパラメータの違いを確認
