---
generated_at: 2026-01-30 13:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-EventNotify.SendNotification.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Speech/src/Internal/SapiInterop/EventNotify.cs` 行10-27 SpNotifySinkクラス
- E-02: `src/libraries/System.Speech/src/Internal/SapiInterop/EventNotify.cs` 行30-121 EventNotifyクラス
- E-03: `src/libraries/System.Speech/src/Internal/SapiInterop/EventNotify.cs` 行17-24 ISpNotifySink.Notify()実装
- E-04: `src/libraries/System.Speech/src/Internal/SapiInterop/EventNotify.cs` 行72-92 SendNotification実装
- E-05: `src/libraries/System.Speech/src/Internal/SapiInterop/EventNotify.cs` 行34-45 コンストラクタ
- E-06: `src/libraries/System.Speech/src/Internal/SapiInterop/EventNotify.cs` 行52-70 Dispose実装
- E-07: `src/libraries/System.Speech/src/Internal/SapiInterop/SapiRecoContext.cs` 行70-72 CreateEventNotify
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 行26 SendNotification定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SpNotifySinkがISpNotifySinkを実装 | E-01 (行10: internal class SpNotifySink : ISpNotifySink) | ○ |
| C-02 | WeakReferenceでEventNotifyを参照 | E-01 (行14: _eventNotifyReference = new WeakReference(eventNotify)) | ○ |
| C-03 | Notify()でEventNotifyをWeakReferenceから取得 | E-03 (行19: EventNotify eventNotify = (EventNotify)_eventNotifyReference.Target) | ○ |
| C-04 | ThreadPool.QueueUserWorkItemでSendNotificationをスケジュール | E-03 (行22: ThreadPool.QueueUserWorkItem(new WaitCallback(eventNotify.SendNotification))) | ○ |
| C-05 | SendNotificationのパラメータはobject ignored | E-04 (行72: internal void SendNotification(object ignored)) | ○ |
| C-06 | lock(this)で排他制御 | E-04 (行74: lock (this)) | ○ |
| C-07 | _sapiEventSourceReference != nullをチェック | E-04 (行77: if (_sapiEventSourceReference != null)) | ○ |
| C-08 | ISpEventSourceをWeakReferenceから取得 | E-04 (行79: ISpEventSource sapiEventSource = (ISpEventSource)_sapiEventSourceReference.Target) | ○ |
| C-09 | SpeechEvent.TryCreateSpeechEventでイベント生成 | E-04 (行84: speechEvent = SpeechEvent.TryCreateSpeechEvent(sapiEventSource, _additionalSapiFeatures, _audioFormat)) | ○ |
| C-10 | speechEventsリストにイベントを追加 | E-04 (行86: speechEvents.Add(speechEvent)) | ○ |
| C-11 | _dispatcher.Post()でイベントをディスパッチ | E-04 (行88: _dispatcher.Post(speechEvents.ToArray())) | ○ |
| C-12 | コンストラクタでSpNotifySinkを作成 | E-05 (行43: _notifySink = new SpNotifySink(this)) | ○ |
| C-13 | SetNotifySink()でSAPIに登録 | E-05 (行44: sapiEventSource.SetNotifySink(_notifySink)) | ○ |
| C-14 | Dispose()でSetNotifySink(null)を呼び出し | E-06 (行64: sapiEventSource.SetNotifySink(null)) | ○ |
| C-15 | SapiRecoContext.CreateEventNotifyでEventNotifyを生成 | E-07 (行72: return new EventNotify(_recoContext, asyncWorker, supportsSapi53)) | ○ |
| C-16 | 通知一覧CSVでSendNotificationが定義されている | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠があります）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] SpNotifySinkとEventNotifyクラスの構造を確認
- [ ] Notify()からSendNotification()への呼び出しフローを確認
- [ ] lock(this)による排他制御が適切か確認
- [ ] WeakReferenceの使用が適切か確認
- [ ] Dispose()でのリソース解放が完全か確認
