---
generated_at: 2026-01-30 13:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：3-INotifyDataErrorInfo.ErrorsChanged

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **WPF 4.5以降でのネイティブサポート**: 外部ドキュメントの確認が必要
  2. **非同期検証のサポート**: インターフェース設計からは確認できるが具体的な実装例なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.ObjectModel/src/System/ComponentModel/INotifyDataErrorInfo.cs`（行8-15）
- E-02: `src/libraries/System.ObjectModel/src/System/ComponentModel/DataErrorsChangedEventArgs.cs`（行9-25）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | INotifyDataErrorInfoインターフェースはErrorsChangedイベントを定義している | E-01（行14） | ○ |
| C-02 | HasErrorsプロパティでエラーの有無を確認できる | E-01（行10） | ○ |
| C-03 | GetErrorsメソッドでエラーを取得できる | E-01（行12） | ○ |
| C-04 | DataErrorsChangedEventArgsはPropertyNameプロパティを持つ | E-02（行23） | ○ |
| C-05 | System.ComponentModel名前空間に属する | E-01, E-02（namespace宣言） | ○ |
| C-06 | イベント引数はEventArgsを継承 | E-02（行9） | ○ |
| C-07 | GetErrorsはIEnumerableを返す | E-01（行12） | ○ |
| C-08 | PropertyNameがnullの場合はオブジェクトレベルエラーを示す | E-02（XMLコメント参照）、.NET仕様 | ○ |
| C-09 | イベントハンドラの型はEventHandler<DataErrorsChangedEventArgs> | E-01（行14） | ○ |
| C-10 | 非同期検証をサポートする設計である | E-01（インターフェース設計） | ○ |
| C-11 | IDataErrorInfoの後継インターフェースである | **根拠なし**（歴史的経緯、外部ドキュメント） | △ |
| C-12 | WPF 4.5以降でネイティブサポート | **根拠なし**（WPFは別リポジトリ） | △ |
| C-13 | GetErrors(null)でオブジェクトレベルエラーを取得 | E-01（GetErrorsのパラメータがnullable） | ○ |
| C-14 | DataErrorsChangedEventArgsのコンストラクタはpropertyNameを受け取る | E-02（行15-18） | ○ |
| C-15 | イベントはマルチキャストデリゲートとして通知される | E-01（eventキーワードの使用） | ○ |
| C-16 | PropertyNameプロパティはvirtualである | E-02（行23） | ○ |

## 4) 不足情報（Unknown / Missing）
- **IDataErrorInfoの後継（C-11）**：`IDataErrorInfo`は同じ名前空間に存在するが、後継関係を示す直接的なコード上の証拠はない。.NETドキュメントの歴史的説明を参照する必要がある。
  - 候補：Microsoft Docs / .NET API Reference
- **WPF 4.5以降のサポート（C-12）**：WPFは別リポジトリ（dotnet/wpf）で管理されている。バインディングでの使用はWPFドキュメントを参照する必要がある。
  - 候補：dotnet/wpf リポジトリ / Microsoft Docs WPF

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェース定義とEventArgs定義は明確
- 0: 低リスク - 3つのメンバー（HasErrors, GetErrors, ErrorsChanged）の役割が明確
- 1: 中リスク - UIフレームワークでの実際の使用は外部ドキュメント依存

## 6) レビュアーチェックリスト（最小）
- [ ] INotifyDataErrorInfo.cs の行10, 12, 14で3つのメンバーを確認
- [ ] DataErrorsChangedEventArgs.cs の PropertyName プロパティを確認
- [ ] GetErrorsの戻り値がIEnumerableであることを確認
- [ ] WPF/UWP/MAUIでの実際の使用例を外部ドキュメントで確認
