---
generated_at: 2026-01-30 13:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：4-INotifyCollectionChanged.CollectionChanged

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **WPFでの増分更新**: 外部ドキュメントの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.ObjectModel/src/System/Collections/Specialized/INotifyCollectionChanged.cs`（行6-21）
- E-02: `src/libraries/System.ObjectModel/src/System/Collections/Specialized/NotifyCollectionChangedEventArgs.cs`（行14-368）
- E-03: `src/libraries/System.ObjectModel/src/System/Collections/ObjectModel/ObservableCollection.cs`（行84, 90-199, 223-235）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | INotifyCollectionChangedインターフェースはCollectionChangedイベントを定義している | E-01（行20） | ○ |
| C-02 | System.Collections.Specialized名前空間に属する | E-01, E-02（namespace宣言） | ○ |
| C-03 | NotifyCollectionChangedAction列挙型で5つのアクションが定義されている | E-02（暗黙的参照、コンストラクタ引数） | ○ |
| C-04 | Add操作時にAction=Addで通知される | E-03（行126） | ○ |
| C-05 | Remove操作時にAction=Removeで通知される | E-03（行112） | ○ |
| C-06 | Replace操作時にAction=Replaceで通知される | E-03（行140） | ○ |
| C-07 | Move操作時にAction=Moveで通知される | E-03（行157） | ○ |
| C-08 | Clear操作時にAction=Resetで通知される | E-03（行96: OnCollectionReset） | ○ |
| C-09 | NewItemsプロパティで追加された項目を取得できる | E-02（行253） | ○ |
| C-10 | OldItemsプロパティで削除された項目を取得できる | E-02（行258） | ○ |
| C-11 | NewStartingIndexプロパティで新しい位置を取得できる | E-02（行263） | ○ |
| C-12 | OldStartingIndexプロパティで古い位置を取得できる | E-02（行268） | ○ |
| C-13 | ObservableCollectionがINotifyCollectionChangedを実装している | E-03（行22） | ○ |
| C-14 | 再入呼び出しがCheckReentrancy()でチェックされる | E-03（行223-235） | ○ |
| C-15 | _blockReentrancyCountで再入防止を管理している | E-03（行27, 189, 196） | ○ |
| C-16 | イベントハンドラの型はNotifyCollectionChangedEventHandler | E-01（行20）, E-02（行274） | ○ |
| C-17 | イベント引数はEventArgsを継承 | E-02（行14） | ○ |
| C-18 | Reset操作時はNewItems/OldItemsがnull | E-02（行26-34） | ○ |
| C-19 | WPFのListBoxなどで増分更新に使用される | **根拠なし**（WPFは別リポジトリ） | △ |
| C-20 | EventArgsCacheでイベント引数がキャッシュされている | E-03（行315-319） | ○ |

## 4) 不足情報（Unknown / Missing）
- **WPFでの増分更新（C-19）**：WPFは別リポジトリ（dotnet/wpf）で管理されている。ItemContainerGeneratorやItemsControlでの使用はWPFドキュメントを参照する必要がある。
  - 候補：dotnet/wpf リポジトリ / Microsoft Docs WPF Data Binding

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェース定義とEventArgs定義は明確
- 0: 低リスク - ObservableCollectionでの実装パターンはソースコードで確認済み
- 0: 低リスク - 5つのアクション（Add/Remove/Replace/Move/Reset）が全て確認済み
- 1: 中リスク - UIフレームワークでの実際の使用は外部ドキュメント依存

## 6) レビュアーチェックリスト（最小）
- [ ] INotifyCollectionChanged.cs の行20でイベント定義を確認
- [ ] NotifyCollectionChangedEventArgs.cs の各コンストラクタを確認
- [ ] ObservableCollection.cs での各操作（Insert, Remove, Set, Move, Clear）でのイベント発火を確認
- [ ] CheckReentrancy() の実装を確認
