---
generated_at: 2026-01-30 13:25:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：6-INotifyCompletion.OnCompleted

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **C#コンパイラのステートマシン生成**: コンパイラ実装はRoslynリポジトリ

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Private.CoreLib/src/System/Runtime/CompilerServices/INotifyCompletion.cs`（行13-35）
- E-02: `src/libraries/System.Private.CoreLib/src/System/Runtime/CompilerServices/TaskAwaiter.cs`（行20, 46-49, 174-187）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | INotifyCompletionインターフェースはOnCompletedメソッドを定義している | E-01（行21） | ○ |
| C-02 | OnCompletedメソッドはAction continuationを引数に取る | E-01（行21） | ○ |
| C-03 | System.Runtime.CompilerServices名前空間に属する | E-01（行11） | ○ |
| C-04 | continuationがnullの場合ArgumentNullExceptionをスローする | E-01（行20: XMLドキュメント）、E-02（行176） | ○ |
| C-05 | async/awaitパターンの基盤となる | E-01（行4-9: コメント） | ○ |
| C-06 | TaskAwaiterがINotifyCompletionを実装している | E-02（行20） | ○ |
| C-07 | OnCompletedInternal静的メソッドで内部処理を行う | E-02（行174-187） | ○ |
| C-08 | task.SetContinuationForAwaitで継続を設定する | E-02（行186） | ○ |
| C-09 | flowExecutionContextパラメータでExecutionContext伝播を制御 | E-02（行48, 174） | ○ |
| C-10 | continueOnCapturedContextパラメータでコンテキストキャプチャを制御 | E-02（行48, 174） | ○ |
| C-11 | ETWイベントが有効な場合、継続をラップする | E-02（行180-183） | ○ |
| C-12 | ICriticalNotifyCompletionはINotifyCompletionを継承している | E-01（行27） | ○ |
| C-13 | C#コンパイラのステートマシン生成で使用される | **根拠なし**（Roslynリポジトリ） | △ |
| C-14 | 操作完了時に継続がスケジュールされる | E-01（行14-15: XMLドキュメント） | ○ |
| C-15 | TaskAwaiter<TResult>もINotifyCompletionを実装 | E-02（行286） | ○ |
| C-16 | OnCompletedはflowExecutionContext=trueで呼び出される | E-02（行48） | ○ |

## 4) 不足情報（Unknown / Missing）
- **C#コンパイラのステートマシン生成（C-13）**：コンパイラの実装はRoslynリポジトリ（dotnet/roslyn）で管理されている。ステートマシンの生成コードはコンパイラ側の責務。
  - 候補：dotnet/roslyn リポジトリ / Microsoft Docs async/await internals

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェース定義は明確
- 0: 低リスク - TaskAwaiterでの実装パターンはソースコードで確認済み
- 1: 中リスク - コンパイラとの相互作用は外部ドキュメント依存

## 6) レビュアーチェックリスト（最小）
- [ ] INotifyCompletion.cs の行21でOnCompletedメソッド定義を確認
- [ ] TaskAwaiter.cs の行46-49でOnCompleted実装を確認
- [ ] TaskAwaiter.cs の行174-187でOnCompletedInternal実装を確認
- [ ] ExecutionContext伝播の制御（flowExecutionContext）を確認
