---
generated_at: 2026-01-30 13:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：7-ICriticalNotifyCompletion.UnsafeOnCompleted

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **C#コンパイラのawaitパターン優先順位**: コンパイラ実装はRoslynリポジトリ

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Private.CoreLib/src/System/Runtime/CompilerServices/INotifyCompletion.cs`（行24-34）
- E-02: `src/libraries/System.Private.CoreLib/src/System/Runtime/CompilerServices/TaskAwaiter.cs`（行20, 46-59, 174-187）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ICriticalNotifyCompletionインターフェースはINotifyCompletionを継承している | E-01（行27） | ○ |
| C-02 | UnsafeOnCompletedメソッドはAction continuationを引数に取る | E-01（行33） | ○ |
| C-03 | System.Runtime.CompilerServices名前空間に属する | E-01（行11） | ○ |
| C-04 | ExecutionContextを伝播しない | E-01（行32: XMLドキュメント）、E-02（行58） | ○ |
| C-05 | TaskAwaiterがICriticalNotifyCompletionを実装している | E-02（行20） | ○ |
| C-06 | OnCompletedInternalでflowExecutionContext=falseで呼び出される | E-02（行58） | ○ |
| C-07 | OnCompletedはflowExecutionContext=trueで呼び出される（比較） | E-02（行48） | ○ |
| C-08 | C#コンパイラがICriticalNotifyCompletion実装時にUnsafeOnCompletedを優先使用 | **根拠なし**（Roslynリポジトリ） | △ |
| C-09 | continuationがnullの場合ArgumentNullExceptionをスローする | E-01（行31: XMLドキュメント）、E-02（行176） | ○ |
| C-10 | async/awaitパターンで使用される | E-01（行25-26: コメント） | ○ |
| C-11 | "Unsafe"はExecutionContext伝播スキップを示す | E-01（行32） | ○ |
| C-12 | パフォーマンス最適化が目的 | E-01（行32: remarksコメント） | ○ |
| C-13 | TaskAwaiter<TResult>もICriticalNotifyCompletionを実装 | E-02（行286） | ○ |
| C-14 | ConfiguredTaskAwaiterもICriticalNotifyCompletionを実装 | E-02（行379） | ○ |
| C-15 | OnCompletedと同じActionデリゲートを受け取る | E-01（行21, 33） | ○ |
| C-16 | 論理コールコンテキストも伝播されない | E-01（行32: ExecutionContext伝播なしの結果として） | ○ |

## 4) 不足情報（Unknown / Missing）
- **C#コンパイラの優先順位（C-08）**：コンパイラの実装はRoslynリポジトリ（dotnet/roslyn）で管理されている。asyncステートマシン生成時のawaiter呼び出しロジックはコンパイラ側の責務。
  - 候補：dotnet/roslyn リポジトリ / Microsoft Docs async internals / C# Language Specification

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェース定義は明確
- 0: 低リスク - TaskAwaiterでの実装パターンはソースコードで確認済み
- 0: 低リスク - OnCompletedとの違い（flowExecutionContext）が明確
- 1: 中リスク - コンパイラとの相互作用は外部ドキュメント依存

## 6) レビュアーチェックリスト（最小）
- [ ] INotifyCompletion.cs の行27でICriticalNotifyCompletionの継承を確認
- [ ] INotifyCompletion.cs の行32-33でUnsafeOnCompletedメソッド定義を確認
- [ ] TaskAwaiter.cs の行46-59でOnCompletedとUnsafeOnCompletedの違いを確認
- [ ] flowExecutionContextパラメータの違い（true vs false）を確認
