---
generated_at: 2026-01-30 13:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 41
  claims_without_evidence: 4
confidence_derived: 0.91
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：41 / 45、根拠なし：4
- 優先レビュー（高）
  1. **日常業務フローのSTEP定義**：プロジェクト固有の業務フロー定義がないため、一般的な開発フローとして記載
  2. **推奨ブラウザのバージョン情報**：最新版推奨としているが具体的なバージョン要件は未確認
  3. **ローカルサーバーのポート番号**：8000番ポートの記載はサンプルコードに基づくが、環境により異なる可能性
  4. **サポート連絡先の詳細**：GitHub以外の公式サポートチャネルの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - プロジェクト概要
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図
- E-05: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 業務要件一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-07: `docs/code-to-docs/画面設計書/1-WasmBrowserSample.md` - Wasm Browser Sample画面設計書
- E-08: `docs/code-to-docs/画面設計書/18-Home（BlazorBasicTestApp）.md` - BlazorBasicTestApp Home画面設計書
- E-09: `docs/code-to-docs/機能設計書/1-CoreCLR.md` - CoreCLR機能設計書
- E-10: `src/mono/sample/wasm/browser/` - Wasm Browser Sampleソースコード
- E-11: `src/mono/wasm/testassets/BlazorBasicTestApp/` - BlazorBasicTestAppソースコード
- E-12: `src/mono/wasm/testassets/BlazorWebWasm/` - BlazorWebWasmソースコード
- E-13: `src/mono/sample/wasm/browser-bench/` - ベンチマークサンプル
- E-14: `src/mono/sample/wasm/simple-raytracer/` - レイトレーシングサンプル
- E-15: `src/mono/wasm/testassets/WasmOnAspNetCore/` - SignalR統合サンプル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | .NET Runtimeはオープンソースのクロスプラットフォームランタイム | E-01 | ○ |
| C-02 | CoreCLRはWindows/Linux/macOS向け高性能ランタイム | E-02, E-09 | ○ |
| C-03 | Monoはモバイル、WebAssembly、組み込み向け | E-02, E-09 | ○ |
| C-04 | 主要業務はランタイム開発、ライブラリ開発、WebAssembly開発 | E-05 | ○ |
| C-05 | 開発業務は5ステップで進行 | **根拠なし** | △ |
| C-06 | ユーザー種別はランタイム開発者、ライブラリ開発者、アプリ開発者 | E-01 | ○ |
| C-07 | 対応プラットフォームにWindows、Linux、macOS、WebAssembly含む | E-01, E-02 | ○ |
| C-08 | 推奨ブラウザはChrome、Edge、Safari、Firefox最新版 | **根拠なし** | △ |
| C-09 | ビルドにはVisual Studio 2022以上が必要（Windows） | E-01 | ○ |
| C-10 | クローンに400-500MBのディスク容量が必要 | E-01 | ○ |
| C-11 | フルビルドに10-20GBのディスク容量が必要 | E-01 | ○ |
| C-12 | build.shでビルド可能 | E-01 | ○ |
| C-13 | -subset clrでCoreClRのみビルド可能 | E-01 | ○ |
| C-14 | Debug/Checked/Release構成がある | E-01 | ○ |
| C-15 | Wasm Browser Sampleは究極の問いへの答え42を表示 | E-03, E-07 | ○ |
| C-16 | main.jsがJavaScriptエントリーポイント | E-07 | ○ |
| C-17 | Program.csがC#メインロジック | E-07 | ○ |
| C-18 | ローカルサーバーはhttp://localhost:8000/で起動 | E-07 | ○ |
| C-19 | Browser Advanced SampleはCSP/preload/prefetch使用 | E-03, E-06 | ○ |
| C-20 | Browser Threading Sampleはマルチスレッド処理デモ | E-03, E-06 | ○ |
| C-21 | BlazorBasicTestAppはホームとカウンターページを持つ | E-03, E-04, E-08 | ○ |
| C-22 | Homeページのパスは/ | E-04, E-08 | ○ |
| C-23 | Counterページのパスは/counter | E-04 | ○ |
| C-24 | Counterはボタンクリックでカウントアップ | E-08 | ○ |
| C-25 | BlazorWebWasmはHome、Counter、Error、Not Foundページを持つ | E-03, E-04 | ○ |
| C-26 | InteractiveWebAssemblyモードで動作 | E-03 | ○ |
| C-27 | ベンチマークサンプルでパフォーマンス測定可能 | E-03, E-06 | ○ |
| C-28 | レイトレーシングサンプルは640x480のCanvas使用 | E-03 | ○ |
| C-29 | チャットアプリはSignalRによるWebSocket通信 | E-03, E-06 | ○ |
| C-30 | CoreCLRテストはsrc/tests/build.shで実行 | E-01 | ○ |
| C-31 | ライブラリテストはdotnet testで実行 | E-01 | ○ |
| C-32 | EventPipeは診断イベントストリーミング機能 | E-02, E-06 | ○ |
| C-33 | EventPipeサンプルにSay Hiボタンがある | E-03 | ○ |
| C-34 | ログプロファイラーでヒープショット取得可能 | E-06 | ○ |
| C-35 | ホットリロードで実行中コード更新可能 | E-02, E-03 | ○ |
| C-36 | ホットリロードサンプルにUpdateボタンがある | E-03 | ○ |
| C-37 | DependencyInjectionでDIコンテナ利用可能 | E-02, E-05 | ○ |
| C-38 | Configurationで設定管理可能 | E-02, E-05 | ○ |
| C-39 | Loggingで統一ログ出力可能 | E-02, E-05 | ○ |
| C-40 | TypeLoadExceptionは依存アセンブリ不足時に発生 | E-09 | ○ |
| C-41 | OutOfMemoryExceptionはメモリ不足時に発生 | E-09 | ○ |
| C-42 | WASM EXIT 0は正常終了を示す | E-08 | ○ |
| C-43 | WASM EXIT 2は異常終了を示す | E-07 | ○ |
| C-44 | GitHubのIssuesでサポートを求められる | E-01 | ○ |
| C-45 | ポート番号8000は環境により異なる可能性 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **開発業務フローのSTEP定義**
  - プロジェクト固有の業務フロー定義ドキュメントが存在しないため、一般的なソフトウェア開発フローに基づいて記載
  - 候補：開発プロセスガイド / ワークフロー定義書 / 開発者ガイド

- **推奨ブラウザの具体的バージョン要件**
  - WebAssemblyの最小サポートバージョンに関する明示的なドキュメントが未確認
  - 候補：ブラウザ互換性マトリクス / システム要件定義

- **ローカル開発サーバーのポート設定**
  - デフォルトポートの設定方法やカスタマイズに関する詳細情報が未確認
  - 候補：起動設定ファイル / launch.json / launchSettings.json

- **公式サポートチャネルの全容**
  - GitHub Issues以外の公式サポートチャネル（メーリングリスト、Discord等）の確認が必要
  - 候補：CONTRIBUTING.md / SUPPORT.md / コミュニティガイド

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: システム概要、主要機能の説明 - README.mdと機能一覧に基づく記載
- **0（低リスク）**: 画面構成とルーティング - 画面一覧と画面遷移図に基づく記載
- **0（低リスク）**: サンプルアプリケーションの操作手順 - 画面設計書に基づく記載
- **1（中リスク）**: 業務フローのSTEP構成 - プロジェクト固有定義がないため一般化
- **1（中リスク）**: エラーメッセージと対処法 - 機能設計書に基づくが網羅性は未確認
- **0（低リスク）**: ビルドコマンドと構成オプション - READMEに基づく記載

## 6) レビュアーチェックリスト（最小）
- [ ] 業務フローのSTEP定義がプロジェクトの実態に合っているか確認
- [ ] 推奨ブラウザのバージョン要件がWebAssembly機能の最小要件を満たしているか確認
- [ ] ローカルサーバーのポート番号がプロジェクト設定と一致しているか確認
- [ ] サンプルアプリケーションの操作手順が最新のコードと一致しているか確認
- [ ] エラーメッセージ一覧の網羅性を確認
- [ ] GitHub以外のサポートチャネルが存在する場合は追記
- [ ] 各ユーザー種別の役割定義がプロジェクトの実態に合っているか確認
