# .NET Runtime 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [開発環境のセットアップ](#2-開発環境のセットアップ)
3. [基本的なビルドと実行](#3-基本的なビルドと実行)

**【業務フローに沿った機能】**
4. [【STEP1】WebAssemblyアプリケーションの作成](#4-step1webassemblyアプリケーションの作成)
5. [【STEP2-3】Blazorアプリケーションの開発](#5-step2-3blazorアプリケーションの開発)
6. [【STEP3-4】サンプルアプリケーションの実行](#6-step3-4サンプルアプリケーションの実行)
7. [【STEP4-5】テストとデバッグ](#7-step4-5テストとデバッグ)

**【サポート機能】**
8. [診断・プロファイリング機能](#8-診断プロファイリング機能)
9. [ホットリロード機能](#9-ホットリロード機能)
10. [拡張ライブラリの利用](#10-拡張ライブラリの利用)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 .NET Runtimeとは

.NET Runtimeは、Microsoftが開発するオープンソースのクロスプラットフォーム対応ランタイムです。本リポジトリには、.NETランタイム、ライブラリ、および共有ホスト（dotnet）インストーラのソースコードが含まれており、ECMA 335仕様に準拠した自己完結型のランタイム環境を提供します。

本プロジェクトは主に以下の用途で使用されます：
- .NETアプリケーションの実行基盤の開発・保守
- WebAssembly（Blazor）アプリケーションの開発
- クロスプラットフォームアプリケーションの作成
- サンプルアプリケーションを通じた機能検証

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **ランタイム開発** | CoreCLR、Monoランタイムのビルド・テスト・デバッグ |
| **ライブラリ開発** | System.Collections、System.Net等の基本クラスライブラリの開発・保守 |
| **WebAssembly開発** | Blazor WebAssemblyアプリケーションの作成・実行・テスト |
| **サンプル検証** | 各種サンプルアプリケーションを使用した機能検証 |
| **診断・分析** | EventPipe、プロファイラーを使用したパフォーマンス分析 |

### 1.3 業務フロー概要

本システムにおける開発業務は、以下の流れで進行します：

```
+---------------------------------------------------------------+
|                        開発業務フロー                           |
+---------------------------------------------------------------+
|                                                               |
|  【STEP 1】開発環境のセットアップとビルド                       |
|      - 必要なツールのインストール                              |
|      - ソースコードのクローン                                  |
|      - ランタイムのビルド                                      |
|      ↓                                                        |
|  【STEP 2】アプリケーションの作成                              |
|      - プロジェクトの作成                                      |
|      - コードの実装                                            |
|      - 依存関係の設定                                          |
|      ↓                                                        |
|  【STEP 3】ローカル環境での実行・確認                          |
|      - アプリケーションのビルド                                |
|      - ローカルサーバーでの実行                                |
|      - ブラウザでの動作確認                                    |
|      ↓                                                        |
|  【STEP 4】テストとデバッグ                                    |
|      - ユニットテストの実行                                    |
|      - プロファイリング・診断                                  |
|      - 問題の特定と修正                                        |
|      ↓                                                        |
|  【STEP 5】検証完了・成果物の確認                              |
|      - テスト結果の確認                                        |
|      - パフォーマンス計測結果の確認                            |
|      - ドキュメントの更新                                      |
|                                                               |
+---------------------------------------------------------------+
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **ランタイム開発者** | CoreCLR/Monoのビルド、JIT/GCの開発・デバッグ、パフォーマンス最適化 |
| **ライブラリ開発者** | 基本クラスライブラリの実装、APIの設計・テスト、ドキュメント作成 |
| **アプリケーション開発者** | サンプルアプリケーションの作成、WebAssembly/Blazorアプリの開発 |
| **QAエンジニア** | テストの実行、バグの報告、パフォーマンステスト |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| CoreCLR | Windows/Linux/macOS向け高性能ランタイム | STEP 1-5 |
| Mono | WebAssembly/モバイル向け軽量ランタイム | STEP 1-5 |
| WasmAppBuilder | WebAssemblyアプリケーションのビルド | STEP 2-3 |
| EventPipe | 診断・プロファイリング | STEP 4 |
| ホットリロード | 実行時コード更新 | STEP 3-4 |
| テストランナー | テストの実行と結果確認 | STEP 4-5 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| ランタイム開発者 | CoreCLR/Monoランタイムの開発・保守を行う |
| ライブラリ開発者 | .NET基本クラスライブラリの開発・テストを行う |
| アプリケーション開発者 | サンプルアプリケーションやWebAssemblyアプリを開発する |
| コントリビュータ | オープンソースとして機能追加やバグ修正を行う |

### 1.6 対応環境

**対応プラットフォーム：**
- Windows (x64, x86, ARM64)
- Linux (x64, ARM64, ARM32)
- macOS (x64, ARM64)
- WebAssembly (WASM/WASI)
- Android/iOS

**推奨開発環境：**
- Visual Studio 2022以上（Windows）
- Visual Studio Code + C# Dev Kit
- JetBrains Rider

**推奨ブラウザ（WebAssembly）：**
- Google Chrome（最新版）
- Microsoft Edge（最新版）
- Safari（最新版）
- Firefox（最新版）

---

## 2. 開発環境のセットアップ

### 2.1 必要条件の確認

開発を開始する前に、以下の要件を確認してください。

**Windowsの場合：**
1. Visual Studio 2022以上がインストールされていること
2. C++ワークロードが有効になっていること
3. Windows SDKがインストールされていること

**Linux/macOSの場合：**
1. Clangがインストールされていること
2. CMakeがインストールされていること
3. 各ディストリビューション固有の依存パッケージがインストールされていること

### 2.2 リポジトリのクローン

1. ターミナルまたはコマンドプロンプトを開きます
2. 以下のコマンドを実行してリポジトリをクローンします：

```bash
git clone https://github.com/dotnet/runtime.git
cd runtime
```

**注意事項：**
- クローンには約400-500MBのディスク容量が必要です
- 展開後は1-1.5GB程度になります
- フルビルドには10-20GBのディスク容量が必要です

### 2.3 ビルドの実行

**全体ビルド（Debug構成）：**

```bash
# Linux/macOS
./build.sh

# Windows
.\build.cmd
```

**サブセットビルド（推奨）：**

```bash
# CoreCLRのみ
./build.sh -subset clr

# ライブラリのみ
./build.sh -subset libs

# CLRとライブラリをRelease構成で
./build.sh -subset clr+libs -c Release
```

---

## 3. 基本的なビルドと実行

### 3.1 ビルド構成の選択

| 構成 | 説明 | 用途 |
|------|------|------|
| Debug | 最適化なし、アサート有効 | デバッグに最適 |
| Checked | 最適化あり、アサート有効（CoreCLR専用） | パフォーマンス確認とデバッグの両立 |
| Release | 最適化あり、アサート無効 | パフォーマンス計測に最適 |

### 3.2 サンプルアプリケーションのビルド

WebAssemblyサンプルをビルドするには：

```bash
cd src/mono/sample/wasm/browser
dotnet build
```

### 3.3 ローカルサーバーでの実行

1. サンプルディレクトリに移動します
2. 以下のコマンドを実行します：

```bash
dotnet run
```

3. ブラウザで `http://localhost:8000/` にアクセスします

---

## 4. 【STEP1】WebAssemblyアプリケーションの作成

> **業務フローでの位置**: 開発環境のセットアップ完了後、WebAssemblyアプリケーションの開発を開始するステップです。

### 4.1 Wasm Browser Sampleの利用

**概要：**
Wasm Browser Sampleは、.NET WebAssemblyの基本的なブラウザサンプルです。JavaScript と C# 間の相互運用（JSImport/JSExport）の使い方を学ぶことができます。

**ファイル構成：**

| ファイル | 役割 |
|---------|------|
| index.html | HTML エントリーポイント |
| main.js | JavaScript エントリーポイント、ランタイム初期化 |
| Program.cs | C# メインロジック、JSImport/JSExport 定義 |

**操作手順：**

1. サンプルディレクトリに移動します
   ```bash
   cd src/mono/sample/wasm/browser
   ```

2. プロジェクトをビルドします
   ```bash
   dotnet build
   ```

3. ローカルサーバーを起動します
   ```bash
   dotnet run
   ```

4. ブラウザで `http://localhost:8000/index.html` にアクセスします

5. 画面に「42」（究極の問いへの答え）が表示されれば成功です

### 4.2 高度なサンプル（Browser Advanced Sample）

**概要：**
Content-Security-Policy（CSP）やpreload/prefetchを使用した高度なサンプルです。

**操作手順：**

1. サンプルディレクトリに移動します
   ```bash
   cd src/mono/sample/wasm/browser-advanced
   ```

2. ビルドと実行
   ```bash
   dotnet build
   dotnet run
   ```

### 4.3 マルチスレッドサンプル（Browser Threading Sample）

**概要：**
WebAssemblyでのマルチスレッド処理をデモンストレーションするサンプルです。長時間計算の進捗を表示します。

**操作手順：**

1. サンプルディレクトリに移動します
   ```bash
   cd src/mono/sample/wasm/browser-threads
   ```

2. ビルドと実行
   ```bash
   dotnet build
   dotnet run
   ```

3. ブラウザで進捗バーと計算結果を確認します

---

## 5. 【STEP2-3】Blazorアプリケーションの開発

> **業務フローでの位置**: WebAssemblyの基本を理解した後、Blazorフレームワークを使用してより高度なWebアプリケーションを開発するステップです。

### 5.1 BlazorBasicTestAppの利用

**概要：**
Blazor WebAssemblyの基本的なテストアプリケーションです。コンポーネントベースのUI開発を学ぶことができます。

**画面構成：**

| 画面 | パス | 説明 |
|------|------|------|
| Home | / | ホームページ、"Hello, world!"を表示 |
| Counter | /counter | カウンター機能、ボタンクリックでカウントアップ |

**操作手順：**

1. アプリケーションディレクトリに移動します
   ```bash
   cd src/mono/wasm/testassets/BlazorBasicTestApp/App
   ```

2. プロジェクトをビルドします
   ```bash
   dotnet build
   ```

3. アプリケーションを実行します
   ```bash
   dotnet run
   ```

4. ブラウザでルートURL（/）にアクセスします

5. ナビゲーションメニューから「Home」「Counter」を選択して画面遷移を確認します

### 5.2 Counter機能の操作

**操作手順：**

1. ナビゲーションメニューから「Counter」を選択します
2. 画面に「Counter」と「Current count: 0」が表示されます
3. 「Click me」ボタンをクリックします
4. カウントが1ずつ増加することを確認します

### 5.3 BlazorWebWasmアプリケーション

**概要：**
より高度なBlazor WebAssemblyアプリケーションです。InteractiveWebAssemblyモードで動作します。

**画面構成：**

| 画面 | パス | 説明 |
|------|------|------|
| Home | / | ホームページ |
| Counter | /counter | InteractiveWebAssemblyモードのカウンター |
| Error | /Error | エラー発生時のエラーページ |
| Not Found | /not-found | 存在しないURLアクセス時の404ページ |

**操作手順：**

1. アプリケーションディレクトリに移動します
   ```bash
   cd src/mono/wasm/testassets/BlazorWebWasm/BlazorWebWasm
   ```

2. ビルドと実行
   ```bash
   dotnet build
   dotnet run
   ```

---

## 6. 【STEP3-4】サンプルアプリケーションの実行

> **業務フローでの位置**: 開発したアプリケーションの動作確認と、各種サンプルを使った機能検証を行うステップです。

### 6.1 ベンチマークサンプル

**概要：**
WebAssemblyのパフォーマンスを測定するためのベンチマークサンプルです。

**操作手順：**

1. サンプルディレクトリに移動します
   ```bash
   cd src/mono/sample/wasm/browser-bench
   ```

2. ビルドと実行
   ```bash
   dotnet build
   dotnet run
   ```

3. ブラウザでベンチマーク結果を確認します

### 6.2 レイトレーシングサンプル

**概要：**
WebAssemblyでのグラフィックス処理をデモンストレーションするレイトレーシングサンプルです。640x480のCanvasにレンダリングします。

**操作手順：**

1. サンプルディレクトリに移動します
   ```bash
   cd src/mono/sample/wasm/simple-raytracer
   ```

2. ビルドと実行
   ```bash
   dotnet build
   dotnet run
   ```

3. ブラウザでレンダリング結果を確認します

### 6.3 チャットアプリケーション（SignalR統合）

**概要：**
ASP.NET CoreとBlazorを統合したリアルタイムチャットアプリケーションです。SignalRによるWebSocket通信をテストできます。

**操作手順：**

1. アプリケーションディレクトリに移動します
   ```bash
   cd src/mono/wasm/testassets/WasmOnAspNetCore
   ```

2. サーバーを起動します
   ```bash
   dotnet run
   ```

3. ブラウザでチャットルーム（/）にアクセスします

4. メッセージを入力して送信を確認します

---

## 7. 【STEP4-5】テストとデバッグ

> **業務フローでの位置**: アプリケーションの品質を確保するため、テストの実行と問題の特定・修正を行うステップです。

### 7.1 ユニットテストの実行

**CoreCLRテストの実行：**

```bash
./src/tests/build.sh
./src/tests/run.sh
```

**ライブラリテストの実行：**

```bash
./build.sh -subset libs.tests
dotnet test src/libraries/System.Collections/tests
```

### 7.2 WebAssemblyテストランナーの使用

**概要：**
Wasm Test Runnerは、WebAssemblyテストを実行するための汎用テストランナーです。

**操作手順：**

1. テストランナーディレクトリに移動します
   ```bash
   cd src/tests/Common/wasm-test-runner
   ```

2. テストを実行します

3. ブラウザでテスト結果を確認します

### 7.3 機能テストの実行

**ホットリロードテスト：**

```bash
cd src/tests/FunctionalTests/WebAssembly/Browser/HotReload
```

**ランタイム設定テスト：**

```bash
cd src/tests/FunctionalTests/WebAssembly/Browser/RuntimeConfig
```

**スタートアップフックテスト：**

```bash
cd src/tests/FunctionalTests/WebAssembly/Browser/StartupHook
```

---

## 8. 診断・プロファイリング機能

### 8.1 EventPipeプロファイリング

**概要：**
EventPipeは、アプリケーションの診断イベントをストリーミングする機能です。パフォーマンス分析に使用できます。

**操作手順：**

1. サンプルディレクトリに移動します
   ```bash
   cd src/mono/sample/wasm/browser-eventpipe
   ```

2. ビルドと実行
   ```bash
   dotnet build
   dotnet run
   ```

3. ブラウザで「Say Hi」ボタンをクリックしてイベントを確認します

### 8.2 ログプロファイラー

**概要：**
ログプロファイラーは、詳細なログ情報を収集してアプリケーションの動作を分析する機能です。

**操作手順：**

1. サンプルディレクトリに移動します
   ```bash
   cd src/mono/sample/wasm/browser-logprofile
   ```

2. ビルドと実行
   ```bash
   dotnet build
   dotnet run
   ```

### 8.3 プロファイラーサンプル

**操作手順：**

1. サンプルディレクトリに移動します
   ```bash
   cd src/mono/sample/wasm/browser-profile
   ```

2. ビルドと実行
   ```bash
   dotnet build
   dotnet run
   ```

3. Sample.Test.TestMeaningの結果を確認します

---

## 9. ホットリロード機能

### 9.1 ホットリロードの概要

ホットリロードは、アプリケーション実行中にコードを変更し、再起動せずに変更を反映する機能です。開発効率を大幅に向上させることができます。

### 9.2 ホットリロードサンプルの使用

**操作手順：**

1. サンプルディレクトリに移動します
   ```bash
   cd src/mono/sample/mbr/browser
   ```

2. ビルドと実行
   ```bash
   dotnet build
   dotnet run
   ```

3. ブラウザで画面を表示します

4. コードを変更します

5. 「Update」ボタンをクリックして変更を反映します

---

## 10. 拡張ライブラリの利用

### 10.1 依存性注入（DI）

**概要：**
Microsoft.Extensions.DependencyInjectionは、DIコンテナの実装を提供します。

**使用例：**

```csharp
var services = new ServiceCollection();
services.AddSingleton<IMyService, MyService>();
var provider = services.BuildServiceProvider();
var service = provider.GetRequiredService<IMyService>();
```

### 10.2 構成管理

**概要：**
Microsoft.Extensions.Configurationは、アプリケーション設定の読み込み機能を提供します。

**使用例：**

```csharp
var config = new ConfigurationBuilder()
    .AddJsonFile("appsettings.json")
    .Build();
var value = config["MySetting"];
```

### 10.3 ロギング

**概要：**
Microsoft.Extensions.Loggingは、統一されたログ記録フレームワークを提供します。

**使用例：**

```csharp
var loggerFactory = LoggerFactory.Create(builder =>
{
    builder.AddConsole();
});
var logger = loggerFactory.CreateLogger<Program>();
logger.LogInformation("Hello, World!");
```

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
======================================================
【STEP 1】開発環境のセットアップとビルド → 2-3章参照
    ↓
【STEP 2】アプリケーションの作成 → 4-5章参照
    ↓
【STEP 3】ローカル環境での実行・確認 → 6章参照
    ↓
【STEP 4】テストとデバッグ → 7-9章参照
    ↓
【STEP 5】検証完了・成果物の確認 → 7章参照
======================================================
```

### 11.1 【開発者】STEP1: 環境セットアップ

毎日の開発開始時に、以下を確認します：

1. リポジトリの最新状態を取得します
   ```bash
   git pull origin main
   ```

2. 必要に応じてビルドを実行します
   ```bash
   ./build.sh -subset clr+libs
   ```

### 11.2 【開発者】STEP2: コード実装

新機能の実装やバグ修正を行います：

1. 作業ブランチを作成します
   ```bash
   git checkout -b feature/my-feature
   ```

2. コードを実装します

3. ローカルでビルドを確認します
   ```bash
   dotnet build
   ```

### 11.3 【開発者】STEP3: 動作確認

ローカル環境でアプリケーションを実行し、動作を確認します：

1. アプリケーションを起動します
   ```bash
   dotnet run
   ```

2. ブラウザで動作を確認します

3. 期待通りの動作であることを確認します

### 11.4 【開発者】STEP4-5: テスト・検証完了

変更をコミットする前にテストを実行します：

1. ユニットテストを実行します
   ```bash
   dotnet test
   ```

2. すべてのテストがパスすることを確認します

3. コードをコミットします
   ```bash
   git add .
   git commit -m "Add feature description"
   ```

---

## 12. よくある質問と対処法

### 12.1 ビルドに関するQ&A

**Q: ビルドが失敗します**

A: 以下を確認してください：
- 必要な開発ツールがすべてインストールされているか
- ディスク容量が十分にあるか（10-20GB必要）
- 環境変数が正しく設定されているか

**Q: サブセットビルドの方法がわかりません**

A: 以下のように `-subset` オプションを使用します：
```bash
./build.sh -subset clr        # CoreCLRのみ
./build.sh -subset libs       # ライブラリのみ
./build.sh -subset clr+libs   # 両方
```

### 12.2 実行に関するQ&A

**Q: WebAssemblyアプリケーションがブラウザで動作しません**

A: 以下を確認してください：
- ブラウザがWebAssemblyをサポートしているか
- 開発者ツールのコンソールでエラーを確認
- CORSの設定が正しいか

**Q: ホットリロードが機能しません**

A: 以下を確認してください：
- ホットリロード対応のプロジェクト設定になっているか
- サポートされている変更の種類か

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| TypeLoadException | 依存アセンブリ不足 | 依存関係を確認し、必要なパッケージを追加 |
| OutOfMemoryException | メモリ不足 | メモリリークの調査、ヒープサイズの調整 |
| JavaScript エラー | WebAssemblyランタイム初期化失敗 | ブラウザコンソールでエラー詳細を確認 |
| WASM EXIT 0 | 正常終了 | これはエラーではなく正常な終了メッセージ |
| WASM EXIT 2 | 異常終了 | コンソールログで詳細なエラー情報を確認 |

### 13.2 よくあるトラブルと解決方法

**トラブル: ビルドが途中で止まる**

解決方法：
1. `git clean -xfd` で一時ファイルをクリーンアップ
2. 再度ビルドを実行
3. メモリ不足の場合は他のアプリケーションを終了

**トラブル: テストが失敗する**

解決方法：
1. テストログを確認して失敗原因を特定
2. 該当するテストを個別に実行して詳細を確認
3. 環境依存の問題かどうかを確認

**トラブル: ブラウザでページが表示されない**

解決方法：
1. 開発者ツールでネットワークタブを確認
2. コンソールエラーを確認
3. サーバーが正しく起動しているか確認

### 13.3 サポートへの連絡方法

問題が解決しない場合は、以下の方法でサポートを求めることができます：

1. **GitHubのIssues**
   - リポジトリの Issues ページで既存の問題を検索
   - 新しい Issue を作成して問題を報告

2. **ディスカッション**
   - GitHub Discussions で質問を投稿

3. **ドキュメント**
   - `docs/` ディレクトリ内のドキュメントを参照
   - 特に `docs/workflow/` 内のビルド・テスト手順を確認

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-01-30 | 初版作成 |

---

*本マニュアルは、.NET Runtimeの開発者向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
