---
generated_at: 2026-01-30 13:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 27
  claims_without_evidence: 3
confidence_derived: 0.90
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：27 / 30、根拠なし：3
- 優先レビュー（高）
  1. **NFT-013 例外処理の堅牢性**：具体的な設計ドキュメントの根拠不足
  2. **NFT-014 GCサーバーモード安定性**：詳細設計ドキュメントの特定が必要
  3. **NFT-025 コールドスタート時間**：具体的な数値基準の根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/pipelines/libraries/stress/http.yml`
- E-02: `eng/pipelines/libraries/stress/ssl.yml`
- E-03: `eng/pipelines/coreclr/gc-longrunning.yml`
- E-04: `eng/pipelines/coreclr/gcstress-extra.yml`
- E-05: `eng/pipelines/coreclr/jitstress.yml`
- E-06: `eng/pipelines/coreclr/jitstress-random.yml`
- E-07: `docs/design/features/tiered-compilation.md`
- E-08: `docs/design/features/DynamicPgo.md`
- E-09: `docs/design/security/System.Collections.Generic.Dictionary.md`
- E-10: `docs/design/security/System.StringComparer.md`
- E-11: `SECURITY.md`
- E-12: `docs/design/features/OsrDetailsAndDebugging.md`
- E-13: `README.md`
- E-14: `eng/pipelines/runtime-wasm.yml`
- E-15: `eng/pipelines/coreclr/r2r.yml`
- E-16: `eng/pipelines/coreclr/crossgen2.yml`
- E-17: `eng/pipelines/libraries/fuzzing/deploy-to-onefuzz.yml`
- E-18: `eng/pipelines/runtime-sanitized.yml`
- E-19: `.CodeQL.yml`
- E-20: `docs/design/features/PinnedHeap.md`
- E-21: `docs/design/features/StringDeduplication.md`
- E-22: `eng/pipelines/runtime-cet.yml`
- E-23: `eng/pipelines/coreclr/hardware-intrinsics.yml`
- E-24: `eng/pipelines/coreclr/runtime-nativeaot-outerloop.yml`
- E-25: `eng/pipelines/runtime-diagnostics.yml`
- E-26: `eng/pipelines/coreclr/crossgen2-outerloop.yml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFT-001: API レスポンスタイム測定 | E-01 | ○ |
| C-02 | NFT-002: GC一時停止時間測定 | E-03 | ○ |
| C-03 | NFT-003: Tiered Compilation性能 | E-07 | ○ |
| C-04 | NFT-004: Dynamic PGO最適化効果 | E-08 | ○ |
| C-05 | NFT-005: HTTP長時間負荷テスト | E-01 | ○ |
| C-06 | NFT-006: SSL/TLS長時間負荷テスト | E-02 | ○ |
| C-07 | NFT-007: GCストレステスト | E-04 | ○ |
| C-08 | NFT-008: JITストレステスト | E-05, E-06 | ○ |
| C-09 | NFT-009: ハッシュフラッディング攻撃耐性 | E-09 | ○ |
| C-10 | NFT-010: 文字列比較セキュリティ | E-10 | ○ |
| C-11 | NFT-011: 脆弱性報告プロセス | E-11 | ○ |
| C-12 | NFT-012: Bounty Program準拠 | E-11 | ○ |
| C-13 | NFT-013: 例外処理の堅牢性 | **根拠なし** | △ |
| C-14 | NFT-014: GCサーバーモード安定性 | **根拠なし** | △ |
| C-15 | NFT-015: OSR動作 | E-12 | ○ |
| C-16 | NFT-016: クロスプラットフォーム動作 | E-13 | ○ |
| C-17 | NFT-017: WebAssembly互換性 | E-14 | ○ |
| C-18 | NFT-018: マルチアーキテクチャ対応 | E-01-E-26 | ○ |
| C-19 | NFT-019: ReadyToRun互換性 | E-15, E-16 | ○ |
| C-20 | NFT-020: ファジングテスト | E-17 | ○ |
| C-21 | NFT-021: Sanitizer検証 | E-18 | ○ |
| C-22 | NFT-022: 静的解析適合 | E-19 | ○ |
| C-23 | NFT-023: ピンドヒープ効率 | E-20 | ○ |
| C-24 | NFT-024: 文字列重複排除効果 | E-21 | ○ |
| C-25 | NFT-025: コールドスタート時間 | **根拠なし** | △ |
| C-26 | NFT-026: CET | E-22 | ○ |
| C-27 | NFT-027: Hardware Intrinsics活用 | E-23 | ○ |
| C-28 | NFT-028: Native AOT互換性 | E-24 | ○ |
| C-29 | NFT-029: 診断機能動作 | E-25 | ○ |
| C-30 | NFT-030: Crossgen2最適化効果 | E-16, E-26 | ○ |

## 4) 不足情報（Unknown / Missing）
- **NFT-013 例外処理の堅牢性**: ランタイム全般の安定性要件として記載したが、具体的な設計ドキュメントや数値基準が見つからなかった
  - 候補：coreclr/vmディレクトリ内の例外処理関連コード / テストケース分析 / 公式ドキュメント
- **NFT-014 GCサーバーモード安定性**: GC設計に関する詳細ドキュメントの特定が必要
  - 候補：docs/design/coreclr/botr/ / GC関連設計書 / gc.cppコメント
- **NFT-025 コールドスタート時間**: 具体的な数値基準の根拠が不足
  - 候補：ベンチマーク結果 / パフォーマンス目標定義書 / リリースノート

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: NFT-001〜008, NFT-016〜030（パイプライン/設計ドキュメントで裏付けあり）
- **1 (中リスク)**: NFT-009〜012（セキュリティ関連、設計ドキュメントあるが実装詳細の検証推奨）
- **2 (高リスク)**: NFT-013, NFT-014, NFT-025（根拠不足、追加調査推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースの合格基準が具体的かつ測定可能か確認
- [ ] 優先度「高」のテストケースがCI/CDパイプラインに含まれているか確認
- [ ] セキュリティテストケース（NFT-009〜012, NFT-026）の網羅性を確認
- [ ] ストレステスト（NFT-005〜008）の実行時間と条件が妥当か確認
- [ ] 根拠なし項目（NFT-013, NFT-014, NFT-025）の基準設定を検討
- [ ] プラットフォーム互換性テスト（NFT-016〜018）がすべての対象プラットフォームをカバーしているか確認
