---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **可用性要件（稼働率・RTO・RPO）**：アプリケーション実装依存のため具体値なし
  2. **ネットワーク変更検出**：実装コードの詳細確認が必要
  3. **一部のプラットフォームサポート**：ビルド設定での確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Net.Http/src/System/Net/Http/HttpClient.cs`
- E-02: `src/libraries/System.Net.Http/src/System/Net/Http/SocketsHttpHandler/HttpConnectionSettings.cs`
- E-03: `src/libraries/System.Net.Http/src/System/Net/Http/GlobalHttpSettings.cs`
- E-04: `src/libraries/System.Net.Http/src/System/Net/Http/SocketsHttpHandler/HttpConnectionPoolManager.cs`
- E-05: `src/libraries/Microsoft.Extensions.Caching.Memory/src/MemoryCacheOptions.cs`
- E-06: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/FixedWindowRateLimiterOptions.cs`
- E-07: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/TokenBucketRateLimiterOptions.cs`
- E-08: `src/installer/managed/Microsoft.NET.HostModel/AppHost/RetryUtil.cs`
- E-09: `src/libraries/System.Data.OleDb/src/System/Data/ProviderBase/DbConnectionPoolOptions.cs`
- E-10: `src/libraries/Microsoft.Extensions.Logging/src/DefaultLoggerLevelConfigureOptions.cs`
- E-11: `src/libraries/System.Private.CoreLib/src/System/Runtime/GCSettings.cs`
- E-12: `src/libraries/System.Private.CoreLib/src/System/Threading/PortableThreadPool.cs`
- E-13: `src/libraries/Microsoft.Extensions.Logging/src/LoggingServiceCollectionExtensions.cs`
- E-14: `src/libraries/Microsoft.Extensions.Diagnostics.Abstractions/src/Metrics/MetricsOptions.cs`
- E-15: `README.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTP クライアントタイムアウト 100秒 | E-01 (line 19: `s_defaultTimeout = TimeSpan.FromSeconds(100)`) | ○ |
| C-02 | サーバーあたり最大接続数デフォルト無制限 | E-03 (line 101-116: `MaxConnectionsPerServer = int.MaxValue`) | ○ |
| C-03 | スレッドプール最大ワーカースレッド数 32,767/1,023/10 | E-12 (line 20-28: `DefaultMaxWorkerThreadCount`) | ○ |
| C-04 | HTTP/2 最大ストリームウィンドウサイズ 16MB | E-03 (line 69: `DefaultHttp2MaxStreamWindowSize = 16 * 1024 * 1024`) | ○ |
| C-05 | CPU使用率閾値 高95%/低80% | E-12 (line 30-31: `CpuUtilizationHigh = 95`, `CpuUtilizationLow = 80`) | ○ |
| C-06 | メモリキャッシュ期限切れスキャン頻度1分 | E-05 (line 29: `TimeSpan.FromMinutes(1)`) | ○ |
| C-07 | メモリキャッシュ圧縮率5% | E-05 (line 17: `_compactionPercentage = 0.05`) | ○ |
| C-08 | IOエラーリトライ回数500回 | E-08 (line 20: `NumberOfRetries = 500`) | ○ |
| C-09 | リトライ待機時間100ミリ秒 | E-08 (line 21: `NumMilliSecondsToWait = 100`) | ○ |
| C-10 | スレッドプールタイムアウト20秒 | E-12 (line 55: `DefaultThreadPoolThreadTimeoutMs = 20 * 1000`) | ○ |
| C-11 | HTTP/2サポートデフォルト有効 | E-03 (line 37-40: `AllowHttp2 = true`) | ○ |
| C-12 | HTTP/3サポート Linux/Windows/macOS で有効 | E-03 (line 44-51: `AllowHttp3`) | ○ |
| C-13 | 接続プールクリーンアップ間隔30秒 | E-04 (line 86-87: `DefaultScavengeSeconds = 30`) | ○ |
| C-14 | デフォルトログレベル Information | E-13 (line 42: `LogLevel.Information`) | ○ |
| C-15 | 固定ウィンドウレートリミッター自動補充デフォルト有効 | E-06 (line 24: `AutoReplenishment = true`) | ○ |
| C-16 | トークンバケットレートリミッター自動補充デフォルト有効 | E-07 (line 30: `AutoReplenishment = true`) | ○ |
| C-17 | GCレイテンシモード5種類 | E-11 (line 15-22: `GCLatencyMode`) | ○ |
| C-18 | LOHコンパクションモード2種類 | E-11 (line 8-12: `GCLargeObjectHeapCompactionMode`) | ○ |
| C-19 | プール接続アイドルタイムアウト設定可能 | E-02 (line 46: `_pooledConnectionIdleTimeout`) | ○ |
| C-20 | プール接続ライフタイム設定可能 | E-02 (line 45: `_pooledConnectionLifetime`) | ○ |
| C-21 | DBプール最小/最大サイズ設定可能 | E-09 (line 9-10: `_minPoolSize`, `_maxPoolSize`) | ○ |
| C-22 | Keep-Alive Ping設定可能 | E-02 (line 48-50: `_keepAlivePingTimeout`, `_keepAlivePingDelay`) | ○ |
| C-23 | プリ認証サポート | E-02 (line 31: `_preAuthenticate`) | ○ |
| C-24 | SSL/TLSクライアント証明書設定 | E-02 (line 60: `_sslOptions`) | ○ |
| C-25 | HTTP バージョン制御 | E-02 (line 58, 76-83: `_maxHttpVersion`) | ○ |
| C-26 | 複数HTTP/2接続有効化 | E-02 (line 62: `_enableMultipleHttp2Connections`) | ○ |
| C-27 | 複数HTTP/3接続有効化 | E-02 (line 64: `_enableMultipleHttp3Connections`) | ○ |
| C-28 | カスタム接続コールバック | E-02 (line 66: `_connectCallback`) | ○ |
| C-29 | プレーンテキストストリームフィルター | E-02 (line 67: `_plaintextStreamFilter`) | ○ |
| C-30 | HTTP/2動的ウィンドウサイジングデフォルト有効 | E-03 (line 54-57: `DisableDynamicHttp2WindowSizing = false`) | ○ |
| C-31 | アクティビティプロパゲーションデフォルト有効 | E-03 (line 17-21: `EnableActivityPropagation = true`) | ○ |
| C-32 | メトリクスハンドラーデフォルト有効 | E-03 (line 26-29: `IsGloballyEnabled = true`) | ○ |
| C-33 | 環境変数によるHTTP/2設定 | E-03 (line 39: `DOTNET_SYSTEM_NET_HTTP_SOCKETSHTTPHANDLER_HTTP2SUPPORT`) | ○ |
| C-34 | 環境変数によるHTTP/3設定 | E-03 (line 50: `DOTNET_SYSTEM_NET_HTTP_SOCKETSHTTPHANDLER_HTTP3SUPPORT`) | ○ |
| C-35 | 環境変数による最大接続数設定 | E-03 (line 107: `DOTNET_SYSTEM_NET_HTTP_SOCKETSHTTPHANDLER_MAXCONNECTIONSPERSERVER`) | ○ |
| C-36 | 環境変数によるスレッドタイムアウト設定 | E-12 (line 63: `DOTNET_ThreadPool_ThreadTimeoutMs`) | ○ |
| C-37 | メモリキャッシュサイズ制限設定可能 | E-05 (line 44-56: `SizeLimit`) | ○ |
| C-38 | DBプール作成タイムアウト設定可能 | E-09 (line 11, 38-41: `_creationTimeout`) | ○ |
| C-39 | ロードバランシングタイムアウト設定可能 | E-09 (line 12, 46-49: `_loadBalanceTimeout`) | ○ |
| C-40 | メトリクス設定 | E-14 (line 16: `Rules`) | ○ |
| C-41 | MITライセンス | E-15 (line 73: `MIT license`) | ○ |
| C-42 | クロスプラットフォームサポート | E-15 (line 16-17) | ○ |
| C-43 | 可用性要件（稼働率・RTO・RPO）はアプリ依存 | **根拠なし** | △ |
| C-44 | ネットワーク変更検出機能 | E-04 (line 48-49: `NetworkChangeCleanup`) - 詳細実装要確認 | △ |
| C-45 | 一部プラットフォームサポート（iOS/Android/WebAssembly） | **ビルド設定確認必要** | △ |

## 4) 不足情報（Unknown / Missing）
- **可用性要件（C-43）**：.NET Runtime はライブラリレベルであり、稼働率・RTO・RPO はアプリケーション実装に依存するため、コードベースから具体的な数値を抽出できない
  - 候補：アプリケーション要件定義書 / 運用マニュアル / SLA ドキュメント
- **ネットワーク変更検出（C-44）**：`NetworkChangeCleanup` クラスの存在は確認できるが、詳細な動作仕様の確認が必要
  - 候補：関連テストコード / 設計ドキュメント
- **一部プラットフォームサポート（C-45）**：iOS/Android/WebAssembly のサポートはビルド設定で確認が必要
  - 候補：`eng/pipelines/` 配下のビルド定義 / `Directory.Build.props`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 性能要件・レート制限・キャッシュ設定 - ソースコードから直接確認可能
- **0（低リスク）**: セキュリティ設定 - 設定オプションの存在を確認済み
- **0（低リスク）**: ログ・GC設定 - ソースコードから直接確認可能
- **1（中リスク）**: 可用性要件 - アプリケーションレベルの要件であり、ランタイムコードからは抽出不可
- **1（中リスク）**: プラットフォームサポート - ビルド設定での追加確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] HTTP タイムアウト設定（100秒）がプロジェクト要件と整合しているか
- [ ] スレッドプール設定がターゲット環境に適切か
- [ ] レート制限オプションがセキュリティ要件を満たすか
- [ ] メモリキャッシュ設定がリソース制約に適合するか
- [ ] ログレベル設定が運用要件に合致するか
- [ ] GC設定がレイテンシ要件に対応しているか
- [ ] 可用性要件についてアプリケーションレベルでの定義が別途存在するか
- [ ] ターゲットプラットフォームのサポートがビルド設定で有効になっているか
