# 非機能要件定義書

## 概要

本ドキュメントは、.NET Runtime プロジェクトから抽出した非機能要件を定義するものです。本プロジェクトは、.NET ランタイム、ライブラリ、および共有ホスト (`dotnet`) インストーラーを構築するためのコードを含んでおり、クロスプラットフォーム対応の高性能ランタイム基盤を提供します。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| HTTP クライアントタイムアウト | 100秒以内（デフォルト） | `HttpClient` のデフォルトタイムアウト値 (`s_defaultTimeout = TimeSpan.FromSeconds(100)`) |
| HTTP 接続タイムアウト | 無制限（デフォルト） | `HttpConnectionSettings._connectTimeout` のデフォルト値 |
| HTTP Expect 100-Continue | カスタマイズ可能 | `_expect100ContinueTimeout` により設定可能 |
| Keep-Alive Ping タイムアウト | カスタマイズ可能 | HTTP/2 接続の Keep-Alive 検証用 |
| 接続プール作成タイムアウト | カスタマイズ可能 | `DbConnectionPoolGroupOptions.CreationTimeout` |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| サーバーあたり最大接続数 | 無制限（デフォルト: `int.MaxValue`） | `GlobalHttpSettings.SocketsHttpHandler.MaxConnectionsPerServer` で設定可能 |
| スレッドプール最大ワーカースレッド数 | 64bit: 32,767 / 32bit: 1,023 / Browser: 10 | `PortableThreadPool.DefaultMaxWorkerThreadCount` |
| HTTP/2 最大ストリームウィンドウサイズ | 16 MB（デフォルト） | `GlobalHttpSettings.SocketsHttpHandler.DefaultHttp2MaxStreamWindowSize` |
| CPU使用率閾値（高） | 95% | スレッドプール最適化の閾値 |
| CPU使用率閾値（低） | 80% | スレッドプール最適化の閾値 |

### メモリキャッシュ設定

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| メモリキャッシュサイズ制限 | カスタマイズ可能 | `MemoryCacheOptions.SizeLimit` |
| 期限切れスキャン頻度 | 1分（デフォルト） | `MemoryCacheOptions.ExpirationScanFrequency` |
| 圧縮率 | 5%（デフォルト） | `MemoryCacheOptions.CompactionPercentage` |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | N/A（ライブラリレベル） | アプリケーション実装に依存 |
| 計画停止時間 | N/A | アプリケーション実装に依存 |
| 障害復旧時間（RTO） | N/A | アプリケーション実装に依存 |
| 目標復旧時点（RPO） | N/A | アプリケーション実装に依存 |

### 接続プール管理

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| プール接続アイドルタイムアウト | カスタマイズ可能 | `HttpConnectionSettings._pooledConnectionIdleTimeout` |
| プール接続ライフタイム | カスタマイズ可能 | `HttpConnectionSettings._pooledConnectionLifetime` |
| クリーンアップタイマー間隔 | 30秒（デフォルト） | `HttpConnectionPoolManager._cleanPoolTimeout` |
| DBプール最小サイズ | カスタマイズ可能 | `DbConnectionPoolGroupOptions.MinPoolSize` |
| DBプール最大サイズ | カスタマイズ可能 | `DbConnectionPoolGroupOptions.MaxPoolSize` |
| ロードバランシングタイムアウト | カスタマイズ可能 | `DbConnectionPoolGroupOptions.LoadBalanceTimeout` |

### リトライ設定

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| IO エラーリトライ回数 | 500回 | `RetryUtil.NumberOfRetries` |
| リトライ待機時間 | 100ミリ秒 | `RetryUtil.NumMilliSecondsToWait` |

### スレッドプールタイムアウト

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| スレッドプールスレッドタイムアウト | 20秒（デフォルト） | `ThreadPoolThreadTimeoutMs` |
| 強制最小ワーカースレッド数 | 環境変数で設定可能 | `ThreadPool_ForceMinWorkerThreads` |
| 強制最大ワーカースレッド数 | 環境変数で設定可能 | `ThreadPool_ForceMaxWorkerThreads` |

## セキュリティ要件

### 認証・認可

- **プリ認証サポート**: `HttpConnectionSettings._preAuthenticate` でプリ認証が可能
- **資格情報管理**: `ICredentials` インターフェースによる資格情報の抽象化
- **プロキシ認証**: Basic/Digest/NTLM/Negotiate 認証のサポート
- **クライアント証明書**: `SslClientAuthenticationOptions` による SSL/TLS クライアント証明書設定
- **偽装レベル**: `TokenImpersonationLevel` による Windows 偽装レベルの制御

### 通信セキュリティ

- **HTTP/2 サポート**: デフォルトで有効（`AllowHttp2 = true`）
- **HTTP/3 サポート**: Linux/Windows/macOS でデフォルト有効
- **TLS/SSL**: `SslClientAuthenticationOptions` による詳細な SSL 設定
- **証明書検証**: システムの証明書チェーン検証を使用

### プロキシ設定

- **デフォルトプロキシ**: `HttpClient.DefaultProxy` でシステムプロキシを使用
- **プロキシ資格情報**: `_defaultProxyCredentials` でプロキシ認証をサポート
- **プロキシ使用フラグ**: `_useProxy` で動的にプロキシ使用を制御

## 拡張性要件

### プロトコルサポート

- **HTTP バージョン管理**: HTTP/1.1, HTTP/2, HTTP/3 のサポート
  - `_maxHttpVersion` で最大 HTTP バージョンを制御
  - `_enableMultipleHttp2Connections` で複数 HTTP/2 接続を有効化
  - `_enableMultipleHttp3Connections` で複数 HTTP/3 接続を有効化

### 接続カスタマイズ

- **カスタム接続コールバック**: `_connectCallback` でカスタム接続ロジックを実装可能
- **プレーンテキストストリームフィルター**: `_plaintextStreamFilter` でストリーム処理をカスタマイズ

### 構成の柔軟性

- **環境変数による設定**: 多くの設定が環境変数でオーバーライド可能
  - `DOTNET_SYSTEM_NET_HTTP_SOCKETSHTTPHANDLER_HTTP2SUPPORT`
  - `DOTNET_SYSTEM_NET_HTTP_SOCKETSHTTPHANDLER_HTTP3SUPPORT`
  - `DOTNET_SYSTEM_NET_HTTP_SOCKETSHTTPHANDLER_MAXCONNECTIONSPERSERVER`
  - `DOTNET_ThreadPool_ThreadTimeoutMs`

### レート制限

- **固定ウィンドウレートリミッター**: `FixedWindowRateLimiter` / `FixedWindowRateLimiterOptions`
  - ウィンドウ期間: カスタマイズ可能
  - 許可制限: カスタマイズ可能
  - キュー制限: カスタマイズ可能
  - 自動補充: デフォルト有効

- **トークンバケットレートリミッター**: `TokenBucketRateLimiter` / `TokenBucketRateLimiterOptions`
  - 補充期間: カスタマイズ可能
  - 期間あたりトークン数: カスタマイズ可能
  - トークン制限: カスタマイズ可能

- **スライディングウィンドウレートリミッター**: `SlidingWindowRateLimiter` / `SlidingWindowRateLimiterOptions`

- **並行実行制限**: `ConcurrencyLimiter` / `ConcurrencyLimiterOptions`

## 保守性要件

### ログ設定

- **デフォルトログレベル**: `Information`
  - `DefaultLoggerLevelConfigureOptions` で設定
- **ログフィルタリング**: `LoggerFilterOptions` によるプロバイダー/カテゴリ別フィルタリング
- **構造化ログ**: `ILogger<T>` インターフェースによる型安全なログ出力

### ガベージコレクション設定

- **GC レイテンシモード**:
  - `Batch`: バッチ処理向け
  - `Interactive`: 対話型アプリ向け（デフォルト）
  - `LowLatency`: 低レイテンシ要件向け
  - `SustainedLowLatency`: 持続的低レイテンシ向け
  - `NoGCRegion`: GC 一時停止領域

- **LOH コンパクションモード**:
  - `Default`: デフォルト動作
  - `CompactOnce`: 1回のみコンパクション

### メトリクス収集

- **診断メトリクス**: `MetricsOptions` によるメトリクス設定
- **HTTP テレメトリ**: `HttpTelemetry` による HTTP リクエスト/レスポンスの追跡
- **アクティビティプロパゲーション**: `DistributedContextPropagator` による分散トレーシング

## 運用・監視要件

### HTTP 診断

- **アクティビティプロパゲーション**: デフォルトで有効
  - `GlobalHttpSettings.DiagnosticsHandler.EnableActivityPropagation`
- **メトリクスハンドラー**: デフォルトで有効
  - `GlobalHttpSettings.MetricsHandler.IsGloballyEnabled`
- **ソケットメトリクス**: `SocketsHttpHandlerMetrics` によるメトリクス収集

### フロー制御

- **HTTP/2 動的ウィンドウサイジング**: デフォルトで有効
  - `DisableDynamicHttp2WindowSizing = false`
- **ストリームウィンドウスケール閾値乗数**: `1.0`（デフォルト）

### Keep-Alive 設定

- **Keep-Alive Ping ポリシー**: `HttpKeepAlivePingPolicy` で設定可能
- **Keep-Alive Ping 遅延**: カスタマイズ可能
- **Keep-Alive Ping タイムアウト**: カスタマイズ可能
- **ハートビートタイマー**: HTTP/2 ping 用

### ネットワーク変更検出

- **ネットワーク変更時クリーンアップ**: `NetworkChangeCleanup` による接続プールのクリーンアップ

## 備考

### プラットフォームサポート

本ランタイムは以下のプラットフォームをサポートしています：

- Windows (x86, x64, ARM64)
- Linux (x64, ARM, ARM64)
- macOS (x64, ARM64)
- Android
- iOS/tvOS
- WebAssembly (Browser)

### ライセンス

.NET Runtime は MIT ライセンスの下で提供されています。

### 参考リンク

- 公式ドキュメント: https://learn.microsoft.com/dotnet/core
- ソースコードインデックス: https://source.dot.net
- API リファレンス: https://learn.microsoft.com/dotnet/api
