---
generated_at: 2026-01-14 21:30:00
metrics:
  claims_total: 42
  claims_with_evidence: 40
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：40 / 42、根拠なし：2
- 優先レビュー（高）
  1. **認証方式の詳細（OIDC/OAuth2.0）**：具体的な設定ファイルからの確認が不足
  2. **カードタイプ一覧のレスポンス例**：データベースシードからの推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Catalog.API/Apis/CatalogApi.cs` - Catalog APIエンドポイント定義
- E-02: `src/Catalog.API/Model/CatalogItem.cs` - CatalogItemモデル定義
- E-03: `src/Catalog.API/Model/PaginatedItems.cs` - ページネーションレスポンス定義
- E-04: `src/Catalog.API/Model/PaginationRequest.cs` - ページネーションリクエスト定義
- E-05: `src/Catalog.API/Model/CatalogBrand.cs` - CatalogBrandモデル定義
- E-06: `src/Catalog.API/Model/CatalogType.cs` - CatalogTypeモデル定義
- E-07: `src/Catalog.API/Program.cs` - Catalog API起動設定
- E-08: `src/Ordering.API/Apis/OrdersApi.cs` - Ordering APIエンドポイント定義
- E-09: `src/Ordering.API/Application/Commands/CancelOrderCommand.cs` - キャンセルコマンド定義
- E-10: `src/Ordering.API/Application/Commands/ShipOrderCommand.cs` - 出荷コマンド定義
- E-11: `src/Ordering.API/Application/Commands/CreateOrderCommand.cs` - 注文作成コマンド定義
- E-12: `src/Ordering.API/Application/Commands/CreateOrderDraftCommand.cs` - ドラフト作成コマンド定義
- E-13: `src/Ordering.API/Application/Commands/CreateOrderDraftCommandHandler.cs` - ドラフトレスポンス定義
- E-14: `src/Ordering.API/Application/Queries/OrderViewModel.cs` - 注文レスポンス定義
- E-15: `src/Ordering.API/Program.cs` - Ordering API起動設定（認証必須）
- E-16: `src/Ordering.API/Extensions/Extensions.cs` - 認証設定
- E-17: `src/Ordering.API/Application/Models/BasketItem.cs` - BasketItemモデル
- E-18: `src/Webhooks.API/Apis/WebHooksApi.cs` - Webhooks APIエンドポイント定義
- E-19: `src/Webhooks.API/Model/WebhookSubscription.cs` - WebhookSubscriptionモデル
- E-20: `src/Webhooks.API/Model/WebhookSubscriptionRequest.cs` - WebhookSubscriptionRequestモデル
- E-21: `src/Webhooks.API/Model/WebhookType.cs` - WebhookType列挙値
- E-22: `src/Webhooks.API/Program.cs` - Webhooks API起動設定（認証必須）
- E-23: `src/Basket.API/Grpc/BasketService.cs` - Basket gRPCサービス実装
- E-24: `src/Basket.API/Proto/basket.proto` - Basket gRPCプロトコル定義
- E-25: `src/Basket.API/Model/CustomerBasket.cs` - CustomerBasketモデル
- E-26: `src/Basket.API/Model/BasketItem.cs` - BasketItemモデル
- E-27: `src/Basket.API/Program.cs` - Basket API起動設定
- E-28: `src/eShop.ServiceDefaults/Extensions.cs` - ヘルスチェックエンドポイント定義
- E-29: `src/Catalog.API/Extensions/Extensions.cs` - AI機能設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Catalog APIのエンドポイント一覧（16種類） | E-01 | ○ |
| C-02 | Catalog APIは認証不要 | E-01, E-07 | ○ |
| C-03 | Catalog APIのV1/V2バージョニング | E-01 | ○ |
| C-04 | CatalogItemモデルのフィールド定義 | E-02 | ○ |
| C-05 | PaginatedItemsレスポンス形式 | E-03 | ○ |
| C-06 | PaginationRequestパラメータ（pageSize=10, pageIndex=0） | E-04 | ○ |
| C-07 | CatalogTypeモデル（id, type） | E-06 | ○ |
| C-08 | CatalogBrandモデル（id, brand） | E-05 | ○ |
| C-09 | GetItemByIdのエラーレスポンス（id <= 0でBadRequest） | E-01 | ○ |
| C-10 | 画像取得のMIMEタイプ対応（png, jpeg, gif等） | E-01 | ○ |
| C-11 | アイテム更新時の価格変更でIntegrationEvent発行 | E-01 | ○ |
| C-12 | Ordering APIのエンドポイント一覧（7種類） | E-08 | ○ |
| C-13 | Ordering APIは認証必須 | E-15 | ○ |
| C-14 | CancelOrderCommandの形式（OrderNumber） | E-09 | ○ |
| C-15 | ShipOrderCommandの形式（OrderNumber） | E-10 | ○ |
| C-16 | CreateOrderCommandの全フィールド | E-11 | ○ |
| C-17 | CreateOrderDraftCommandの形式 | E-12 | ○ |
| C-18 | OrderDraftDTOレスポンス形式 | E-13 | ○ |
| C-19 | Orderレスポンス形式（OrderViewModel） | E-14 | ○ |
| C-20 | OrderSummaryレスポンス形式 | E-14 | ○ |
| C-21 | CardTypeレスポンス形式 | E-14 | ○ |
| C-22 | CreateOrderRequestの形式 | E-08 | ○ |
| C-23 | x-requestidヘッダー必須（Guid形式） | E-08 | ○ |
| C-24 | 認証方式がOIDC/OAuth2.0 | E-16 | △ |
| C-25 | Webhooks APIのエンドポイント一覧（4種類） | E-18 | ○ |
| C-26 | Webhooks APIは認証必須 | E-22 | ○ |
| C-27 | WebhookSubscriptionモデル定義 | E-19 | ○ |
| C-28 | WebhookSubscriptionRequestのバリデーション | E-20 | ○ |
| C-29 | WebhookType列挙値（3種類） | E-21 | ○ |
| C-30 | Webhook作成時のGrantURL検証 | E-18 | ○ |
| C-31 | Basket APIのgRPCサービス定義 | E-24 | ○ |
| C-32 | Basket APIの3メソッド（GetBasket, UpdateBasket, DeleteBasket） | E-23, E-24 | ○ |
| C-33 | GetBasketはAllowAnonymous | E-23 | ○ |
| C-34 | UpdateBasket/DeleteBasketは認証必須 | E-23 | ○ |
| C-35 | gRPCエラーステータス（UNAUTHENTICATED, NOT_FOUND） | E-23 | ○ |
| C-36 | CustomerBasket/BasketItemモデル | E-25, E-26 | ○ |
| C-37 | ヘルスチェックエンドポイント（/health, /alive） | E-28 | ○ |
| C-38 | AI機能（セマンティック検索）の条件 | E-01, E-29 | ○ |
| C-39 | RabbitMQイベント駆動アーキテクチャ | E-29, E-16 | ○ |
| C-40 | APIバージョニングのサポート | E-01, E-07 | ○ |
| C-41 | CardType一覧のレスポンス例（Amex, Visa, MasterCard） | E-14 | △ |
| C-42 | ProblemDetails形式のエラーレスポンス | E-01, E-08, E-18 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-24（認証方式の詳細）：認証設定は`AddDefaultAuthentication()`を呼び出しているが、具体的なOIDC/OAuth2.0設定ファイル（appsettings.jsonやIdentity Server設定）の直接確認ができていない
  - 候補：appsettings.json / Identity.API/Configuration/Config.cs / eShop.AppHost設定
- C-41（カードタイプ一覧の具体的な値）：OrderQueriesの実装でデータベースから取得されるが、シードデータの直接確認ができていない
  - 候補：Ordering.Infrastructure/OrderingContextSeed.cs / 初期データスクリプト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - エンドポイントURL、HTTPメソッド、リクエスト/レスポンス形式（ソースコードから直接確認）
- 0: 低リスク - モデル定義、バリデーションルール（モデルクラスから直接確認）
- 1: 中リスク - 認証方式の詳細（OIDC設定の直接確認が不足）
- 0: 低リスク - gRPCサービス定義（.protoファイルから直接確認）
- 0: 低リスク - エラーレスポンス形式（コードから直接確認）
- 1: 中リスク - サンプルデータ（実際のシードデータとの整合性未確認）

## 6) レビュアーチェックリスト（最小）
- [ ] 認証方式の詳細がIdentity.API/Configuration/Config.csと整合しているか確認
- [ ] カードタイプ一覧がデータベースシードデータと一致するか確認
- [ ] 各APIのベースURL（ホスト名）が実環境と一致するか確認
- [ ] gRPCのポート番号やSSL設定が本番環境と一致するか確認
- [ ] サンプルJSONのフィールド名がシリアライゼーション設定と一致するか確認
- [ ] Integration Event名がRabbitMQ設定と一致するか確認
