# eShop Reference Application - "AdventureWorks"

## 概要

eShopは、.NET Aspireを使用したマイクロサービスベースのECサイトリファレンスアプリケーションです。クラウドネイティブなアーキテクチャのベストプラクティスを実装しており、カタログ管理、買い物かご、注文処理、認証、Webhook通知などの機能を備えた本格的なECシステムのサンプルとして設計されています。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| 商品カタログ | 商品一覧の表示、検索、フィルタリング機能。PostgreSQL + pgvectorによるベクトル検索対応 |
| 買い物かご | Redisを使用した高速なセッションベースの買い物かご管理 |
| 注文処理 | ドメイン駆動設計（DDD）パターンを採用した注文管理システム |
| 認証・認可 | Duende IdentityServerによるOAuth2/OpenID Connect認証 |
| Webhook通知 | 注文ステータス変更時のWebhook通知機能 |
| AI連携 | Azure OpenAI/Ollamaによるチャット機能（オプション） |
| モバイルBFF | YARPリバースプロキシによるモバイルアプリ向けBFFパターン |

## 技術スタック

### コア

- フレームワーク: .NET 10 / ASP.NET Core 10
- アーキテクチャ: .NET Aspire (クラウドネイティブオーケストレーション)
- 言語: C# 13
- データベース: PostgreSQL (pgvector拡張によるベクトル検索対応)
- メッセージング: RabbitMQ
- キャッシュ: Redis
- 認証: Duende IdentityServer

### 主要ライブラリ

- Entity Framework Core 10 (ORM)
- gRPC (サービス間通信)
- MediatR (CQRSパターン)
- FluentValidation (バリデーション)
- OpenTelemetry (分散トレーシング)
- YARP (リバースプロキシ)
- Blazor (フロントエンドUI)

## ディレクトリ構成

```
eShop-main/
├── src/                          # ソースコード
│   ├── eShop.AppHost/            # .NET Aspire AppHost（オーケストレーション）
│   ├── eShop.ServiceDefaults/    # サービス共通設定
│   ├── Basket.API/               # 買い物かごAPI（gRPC）
│   ├── Catalog.API/              # 商品カタログAPI
│   ├── Ordering.API/             # 注文API
│   ├── Ordering.Domain/          # 注文ドメインモデル（DDD）
│   ├── Ordering.Infrastructure/  # 注文インフラストラクチャ層
│   ├── OrderProcessor/           # 注文処理ワーカー
│   ├── PaymentProcessor/         # 決済処理ワーカー
│   ├── Identity.API/             # 認証・認可API
│   ├── Webhooks.API/             # Webhook API
│   ├── WebhookClient/            # Webhookクライアント
│   ├── WebApp/                   # Blazor Webアプリケーション
│   ├── WebAppComponents/         # Blazor共有コンポーネント
│   ├── ClientApp/                # .NET MAUIモバイルアプリ
│   ├── HybridApp/                # Blazor Hybridアプリ
│   ├── EventBus/                 # イベントバス抽象化
│   ├── EventBusRabbitMQ/         # RabbitMQイベントバス実装
│   ├── IntegrationEventLogEF/    # 統合イベントログ
│   └── Shared/                   # 共有コード
├── tests/                        # テストコード
│   ├── Basket.UnitTests/         # 買い物かご単体テスト
│   ├── Catalog.FunctionalTests/  # カタログ機能テスト
│   ├── Ordering.UnitTests/       # 注文単体テスト
│   ├── Ordering.FunctionalTests/ # 注文機能テスト
│   └── ClientApp.UnitTests/      # クライアントアプリ単体テスト
├── e2e/                          # E2Eテスト（Playwright）
├── build/                        # ビルドスクリプト
└── img/                          # ドキュメント用画像
```

## セットアップ

### 必要条件

- .NET 10 SDK
- Docker Desktop
- (Windows) Visual Studio 2022 version 17.10以降（ASP.NET and web development + .NET Aspire SDK）
- (オプション) Visual Studio Code with C# Dev Kit

### インストール手順

1. リポジトリをクローン
```bash
git clone https://github.com/dotnet/eshop
cd eshop
```

2. Docker Desktopが起動していることを確認

3. アプリケーションを起動

**Visual Studio (Windows)**
- `eShop.Web.slnf`を開く
- `eShop.AppHost`をスタートアッププロジェクトに設定
- Ctrl+F5で実行

**ターミナル**
```bash
dotnet run --project src/eShop.AppHost/eShop.AppHost.csproj
```

4. コンソールに表示されるAspireダッシュボードのURLにアクセス
```
Login to the dashboard at: http://localhost:19888/login?t=uniquelogincodeforyou
```

### Azure OpenAI連携（オプション）

1. `src/eShop.AppHost/appsettings.json`に接続情報を追加
```json
{
  "ConnectionStrings": {
    "OpenAi": "Endpoint=xxx;Key=xxx;"
  }
}
```

2. `src/eShop.AppHost/Program.cs`で`useOpenAI`を`true`に変更

### Azureへのデプロイ

Azure Developer CLI (azd)を使用してAzureにデプロイ可能です。

```bash
azd auth login
azd init
azd up
```

## 開発

### ビルド

```bash
dotnet build eShop.slnx
```

### テスト実行

**単体テスト・機能テスト**
```bash
dotnet test eShop.slnx
```

**E2Eテスト（Playwright）**
```bash
npm install
npx playwright install
npx playwright test
```

注意: 機能テストはAspireホストを使用してテストコンテナを起動するため、Dockerが必要です。

### コード品質

- EditorConfig (`.editorconfig`) によるコードスタイル統一
- MarkdownLint によるドキュメント品質チェック
- Spectral によるAPI仕様検証

### テストユーザー

デフォルトのテストユーザー情報:
- Email: `jane@example.com`
- Password: 認証画面から確認

### デモデータ

サンプルカタログデータは`src/Catalog.API/Setup/catalog.json`で定義されています。商品名・説明はGPT-35-Turboで生成され、商品画像はDALL-E 3で生成されたものです。
