---
generated_at: 2026-01-14 20:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **テストユーザー情報**：パスワード情報の根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `README.md` - オリジナルのREADMEファイル
- E-02: `eShop.slnx` - ソリューション構成ファイル
- E-03: `global.json` - .NET SDKバージョン設定
- E-04: `Directory.Packages.props` - NuGetパッケージバージョン管理
- E-05: `src/eShop.AppHost/Program.cs` - Aspire AppHostメインプログラム
- E-06: `src/WebApp/WebApp.csproj` - WebAppプロジェクトファイル
- E-07: `src/Catalog.API/Catalog.API.csproj` - Catalog APIプロジェクトファイル
- E-08: `src/Ordering.API/Ordering.API.csproj` - Ordering APIプロジェクトファイル
- E-09: `src/Basket.API/Basket.API.csproj` - Basket APIプロジェクトファイル
- E-10: `src/Identity.API/Identity.API.csproj` - Identity APIプロジェクトファイル
- E-11: `package.json` - Node.jsパッケージ設定
- E-12: `playwright.config.ts` - Playwright設定ファイル
- E-13: `tests/README.md` - テストドキュメント
- E-14: `CONTRIBUTING.md` - コントリビューションガイド
- E-15: `e2e/` - E2Eテストディレクトリ構成

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | .NET Aspireを使用したマイクロサービスアプリケーション | E-01, E-05 | ○ |
| C-02 | .NET 10 / ASP.NET Core 10フレームワーク | E-03, E-04 | ○ |
| C-03 | PostgreSQLデータベース使用 | E-05 | ○ |
| C-04 | pgvectorによるベクトル検索対応 | E-05, E-07 | ○ |
| C-05 | RabbitMQメッセージング使用 | E-05 | ○ |
| C-06 | Redisキャッシュ使用 | E-05, E-09 | ○ |
| C-07 | Duende IdentityServer認証 | E-04, E-10 | ○ |
| C-08 | gRPC通信対応 | E-04, E-06, E-09 | ○ |
| C-09 | MediatRによるCQRSパターン | E-04 | ○ |
| C-10 | FluentValidationバリデーション | E-04, E-08 | ○ |
| C-11 | OpenTelemetry分散トレーシング | E-04 | ○ |
| C-12 | YARPリバースプロキシ | E-04, E-05 | ○ |
| C-13 | Blazor UIフレームワーク | E-06 | ○ |
| C-14 | Entity Framework Core使用 | E-04, E-07, E-08 | ○ |
| C-15 | eShop.AppHostプロジェクト存在 | E-02, E-05 | ○ |
| C-16 | Basket.APIプロジェクト存在 | E-02, E-09 | ○ |
| C-17 | Catalog.APIプロジェクト存在 | E-02, E-07 | ○ |
| C-18 | Ordering.APIプロジェクト存在 | E-02, E-08 | ○ |
| C-19 | Identity.APIプロジェクト存在 | E-02, E-10 | ○ |
| C-20 | Webhooks.APIプロジェクト存在 | E-02, E-05 | ○ |
| C-21 | ClientAppモバイルアプリ存在 | E-02 | ○ |
| C-22 | Azure OpenAI連携機能 | E-01, E-05, E-07 | ○ |
| C-23 | Ollama連携機能 | E-05 | ○ |
| C-24 | Playwrightによる E2Eテスト | E-11, E-12, E-15 | ○ |
| C-25 | 機能テストにDocker必要 | E-13 | ○ |
| C-26 | EditorConfigによるコードスタイル統一 | E-02 | ○ |
| C-27 | Azure Developer CLI対応 | E-01 | ○ |
| C-28 | テストユーザーメールアドレス jane@example.com | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **テストユーザーのパスワード情報**: e2eテストのセットアップファイル（`e2e/login.setup.ts`）を詳細に確認する必要あり
  - 候補：`e2e/login.setup.ts` / Identity.APIのシード設定 / appsettings.json

## 5) リスクフラグ（レビュー観点）
- リスクレベル 0（低リスク）: 全体的にソースコードとの整合性が高い
- リスクレベル 1（中リスク）: テストユーザー情報は実際のIdentity.APIのシード処理を確認することを推奨

## 6) レビュアーチェックリスト（最小）
- [ ] .NET 10 SDKのバージョン要件がglobal.jsonと一致しているか確認
- [ ] Docker Desktopの必要性がAppHost起動時に正しく伝わるか確認
- [ ] Azure OpenAI設定手順がappsettings.jsonの実際の構造と一致するか確認
- [ ] テストユーザー情報の根拠をIdentity.APIのシードデータから確認
- [ ] ディレクトリ構成が最新のプロジェクト構造を反映しているか確認
