---
generated_at: 2026-01-14 22:55:00
metrics:
  claims_total: 45
  claims_with_evidence: 43
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：43 / 45、根拠なし：2
- 優先レビュー（高）
  1. **DDDパターンの網羅性**：一部パターンの説明が省略されている可能性
  2. **テスト関連ドキュメントの参照**：テストコード例の追加検討

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Catalog.API/Program.cs`
- E-02: `src/Catalog.API/Model/CatalogItem.cs`
- E-03: `src/Catalog.API/Apis/CatalogApi.cs`
- E-04: `src/Catalog.API/Infrastructure/CatalogContext.cs`
- E-05: `src/Catalog.API/Extensions/Extensions.cs`
- E-06: `src/eShop.AppHost/Program.cs`
- E-07: `src/eShop.ServiceDefaults/Extensions.cs`
- E-08: `src/Ordering.Domain/SeedWork/Entity.cs`
- E-09: `src/Ordering.Domain/AggregatesModel/OrderAggregate/Order.cs`
- E-10: `src/Ordering.API/Application/Commands/CreateOrderCommand.cs`
- E-11: `src/Ordering.API/Application/Commands/CreateOrderCommandHandler.cs`
- E-12: `src/Basket.API/Grpc/BasketService.cs`
- E-13: `src/WebApp/Program.cs`
- E-14: `src/WebApp/Services/BasketState.cs`
- E-15: `src/WebApp/Components/Pages/Catalog/Catalog.razor`
- E-16: `src/WebApp/Components/Pages/Checkout/Checkout.razor`
- E-17: `src/EventBusRabbitMQ/RabbitMQEventBus.cs`
- E-18: `src/Ordering.Infrastructure/Repositories/OrderRepository.cs`
- E-19: `README.md`
- E-20: `eShop.slnx`
- E-21: `Directory.Packages.props`
- E-22: `global.json`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | eShopは.NET Aspireを使用したクラウドネイティブアプリケーション | E-06, E-19 | ○ |
| C-02 | C#はTop-level statementsをサポート | E-01, E-13 | ○ |
| C-03 | CatalogItemにはRequired属性でバリデーション | E-02 | ○ |
| C-04 | Nullable参照型を使用（string?） | E-02 | ○ |
| C-05 | Minimal APIsでエンドポイント定義 | E-03 | ○ |
| C-06 | Entity Framework Coreでデータアクセス | E-04 | ○ |
| C-07 | PostgreSQLをデータベースとして使用 | E-06, E-21 | ○ |
| C-08 | Redisをキャッシュとして使用 | E-06 | ○ |
| C-09 | RabbitMQをイベントバスとして使用 | E-06, E-17 | ○ |
| C-10 | DDDのEntityパターンを採用 | E-08 | ○ |
| C-11 | Aggregate Rootパターンを採用 | E-09 | ○ |
| C-12 | CQRSパターンをOrdering.APIで採用 | E-10, E-11 | ○ |
| C-13 | MediatRを使用してコマンドハンドリング | E-11, E-21 | ○ |
| C-14 | gRPCでBasket.APIを実装 | E-12 | ○ |
| C-15 | Primary Constructor（C#12）を使用 | E-12, E-14 | ○ |
| C-16 | BlazorでWebAppを実装 | E-13, E-15 | ○ |
| C-17 | OpenTelemetryで可観測性を実装 | E-07 | ○ |
| C-18 | Health Checksを実装 | E-07 | ○ |
| C-19 | API Versioningを実装 | E-01, E-03 | ○ |
| C-20 | TypedResultsパターンを使用 | E-03 | ○ |
| C-21 | Integration Eventsでサービス間通信 | E-05, E-17 | ○ |
| C-22 | Domain Eventsを使用 | E-09 | ○ |
| C-23 | Repository Patternを採用 | E-18 | ○ |
| C-24 | Unit of Workパターンを採用 | E-18 | ○ |
| C-25 | 命名規則：{Domain}.API形式 | E-20 | ○ |
| C-26 | 命名規則：I{Name}でインターフェース | E-17, E-18 | ○ |
| C-27 | 命名規則：{Name}Handlerでハンドラクラス | E-11 | ○ |
| C-28 | ディレクトリ構造：src/以下にサービス | E-20 | ○ |
| C-29 | ディレクトリ構造：tests/以下にテスト | E-20 | ○ |
| C-30 | .NET 9/10をターゲット | E-22 | ○ |
| C-31 | Duende IdentityServerで認証 | E-21 | ○ |
| C-32 | YARPでBFFを実装 | E-06 | ○ |
| C-33 | Pgvectorで埋め込みベクトル検索 | E-02, E-21 | ○ |
| C-34 | OpenAI/Ollamaの統合オプション | E-06 | ○ |
| C-35 | FluentValidationを使用 | E-21 | ○ |
| C-36 | Dapperを部分的に使用 | E-21 | ○ |
| C-37 | 拡張メソッドでサービス登録 | E-05, E-07 | ○ |
| C-38 | Pollyでレジリエンス実装 | E-07, E-17 | ○ |
| C-39 | BasketStateでカート状態管理 | E-14 | ○ |
| C-40 | チェックアウトフローでOrderingService呼び出し | E-14, E-16 | ○ |
| C-41 | 商品一覧でCatalogService呼び出し | E-15 | ○ |
| C-42 | OrderProcessorがバックグラウンド処理 | E-06 | ○ |
| C-43 | PaymentProcessorが決済処理 | E-06 | ○ |
| C-44 | WebhooksAPIでWebhook機能提供 | E-06, E-20 | ○ |
| C-45 | DDDのValue Objectパターンを使用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-45: DDDのValue Objectパターンについて
  - Addressクラスなどが該当するが、直接的なコード確認が不足
  - 候補：`src/Ordering.Domain/AggregatesModel/OrderAggregate/Address.cs`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 言語基礎セクション（C#構文は標準的な説明）
- 0: 低リスク - ディレクトリ構造（実際のファイル構造と一致）
- 0: 低リスク - 命名規則（コードから抽出した実際のパターン）
- 1: 中リスク - アーキテクチャ図（Mermaid図は概念的なもの、詳細は要確認）
- 0: 低リスク - 業務フロー追跡（実コードを引用）

## 6) レビュアーチェックリスト（最小）
- [ ] 言語基礎セクションのコード例が最新のソースと一致しているか
- [ ] ディレクトリ構造が実際のプロジェクト構造と一致しているか
- [ ] 命名規則が全サービスで一貫しているか
- [ ] アーキテクチャ図がシステム構成を正確に反映しているか
- [ ] 業務フロー追跡の例が実際の処理順序と一致しているか
- [ ] DDDパターン（Value Object等）の説明が十分か
- [ ] 参考資料のリンクが有効か
